@extends('layouts.main')

@section('extra-css')
    <link type="text/css" rel="stylesheet" href="{{asset('css/dashboard-style.css')}}">
@endsection

@section('content')
    <!-- wrapper-->
    <div id="wrapper">
        <!-- content-->
        <div class="content">
            <!--  section  -->
            <section class="parallax-section dashboard-header-sec gradient-bg" data-scrollax-parent="true">
                <div class="container">
                    <div class="dashboard-breadcrumbs breadcrumbs"><a href="#">Home</a><a href="#">Dashboard</a><span>Main page</span></div>
                    <!--Tariff Plan menu-->
                    <div   class="tfp-btn"><span>Tariff Plan : </span> <strong>Extended</strong></div>
                    <div class="tfp-det">
                        <p>You Are on <a href="#">Extended</a> . Use link bellow to view details or upgrade. </p>
                        <a href="#" class="tfp-det-btn color2-bg">Details</a>
                    </div>
                    <!--Tariff Plan menu end-->
                    <div class="dashboard-header_conatiner fl-wrap dashboard-header_title">
                        <h1>Welcome  : <span>Alisa Noory</span></h1>
                    </div>
                </div>
                <div class="clearfix"></div>
                <div class="dashboard-header fl-wrap">
                    <div class="container">
                        <div class="dashboard-header_conatiner fl-wrap">
                            <div class="dashboard-header-avatar">
                                <img src="images/avatar/1.jpg" alt="">
                                <a href="dashboard-myprofile.html" class="color-bg edit-prof_btn"><i class="fal fa-edit"></i></a>
                            </div>
                            <div class="dashboard-header-stats-wrap">
                                <div class="dashboard-header-stats">
                                    <div class="swiper-container">
                                        <div class="swiper-wrapper">
                                            <!--  dashboard-header-stats-item -->
                                            <div class="swiper-slide">
                                                <div class="dashboard-header-stats-item">
                                                    <i class="fal fa-map-marked"></i>
                                                    Active Listings	
                                                    <span>21</span>
                                                </div>
                                            </div>
                                            <!--  dashboard-header-stats-item end -->
                                            <!--  dashboard-header-stats-item -->
                                            <div class="swiper-slide">
                                                <div class="dashboard-header-stats-item">
                                                    <i class="fal fa-chart-bar"></i>
                                                    Listing Views
                                                    <span>1054</span>	
                                                </div>
                                            </div>
                                            <!--  dashboard-header-stats-item end -->
                                            <!--  dashboard-header-stats-item -->
                                            <div class="swiper-slide">
                                                <div class="dashboard-header-stats-item">
                                                    <i class="fal fa-comments-alt"></i>
                                                    Total Reviews
                                                    <span>79</span>	
                                                </div>
                                            </div>
                                            <!--  dashboard-header-stats-item end -->
                                            <!--  dashboard-header-stats-item -->
                                            <div class="swiper-slide">
                                                <div class="dashboard-header-stats-item">
                                                    <i class="fal fa-heart"></i>
                                                    Times Bookmarked
                                                    <span>654</span>	
                                                </div>
                                            </div>
                                            <!--  dashboard-header-stats-item end -->
                                        </div>
                                    </div>
                                </div>
                                <!--  dashboard-header-stats  end -->
                                <div class="dhs-controls">
                                    <div class="dhs dhs-prev"><i class="fal fa-angle-left"></i></div>
                                    <div class="dhs dhs-next"><i class="fal fa-angle-right"></i></div>
                                </div>
                            </div>
                            <!--  dashboard-header-stats-wrap end -->
                            <a class="add_new-dashboard">Add Listing <i class="fal fa-layer-plus"></i></a>
                        </div>
                    </div>
                </div>
                <div class="gradient-bg-figure" style="right:-30px;top:10px;"></div>
                <div class="gradient-bg-figure" style="left:-20px;bottom:30px;"></div>
                <div class="circle-wrap" style="left:120px;bottom:120px;" data-scrollax="properties: { translateY: '-200px' }">
                    <div class="circle_bg-bal circle_bg-bal_small"></div>
                </div>
                <div class="circle-wrap" style="right:420px;bottom:-70px;" data-scrollax="properties: { translateY: '150px' }">
                    <div class="circle_bg-bal circle_bg-bal_big"></div>
                </div>
                <div class="circle-wrap" style="left:420px;top:-70px;" data-scrollax="properties: { translateY: '100px' }">
                    <div class="circle_bg-bal circle_bg-bal_big"></div>
                </div>
                <div class="circle-wrap" style="left:40%;bottom:-70px;"  >
                    <div class="circle_bg-bal circle_bg-bal_middle"></div>
                </div>
                <div class="circle-wrap" style="right:40%;top:-10px;"  >
                    <div class="circle_bg-bal circle_bg-bal_versmall" data-scrollax="properties: { translateY: '-350px' }"></div>
                </div>
                <div class="circle-wrap" style="right:55%;top:90px;"  >
                    <div class="circle_bg-bal circle_bg-bal_versmall" data-scrollax="properties: { translateY: '-350px' }"></div>
                </div>
            </section>
            <!--  section  end-->
            <!--  section  -->
            <section class="gray-bg main-dashboard-sec" id="sec1">
                <div class="container">
                    <!--  dashboard-menu-->
                    <div class="col-md-3">
                        <div class="mob-nav-content-btn color2-bg init-dsmen fl-wrap"><i class="fal fa-bars"></i> Dashboard menu</div>
                        <div class="clearfix"></div>
                        <div class="fixed-bar fl-wrap" id="dash_menu">
                            @include('layouts.profileMenu')
                        </div>
                        <a class="back-tofilters color2-bg custom-scroll-link fl-wrap" href="#dash_menu">Back to Menu<i class="fas fa-caret-up"></i></a>
                        <div class="clearfix"></div>
                    </div>
                    <!-- dashboard-menu  end-->
                    <!-- dashboard content-->
                    <div class="col-md-9">
                        <form action="/update/profile" method="post">
                            @csrf
                            <div class="dashboard-title fl-wrap">
                                <h3>Your Profile</h3>
                            </div>
                            <!-- profile-edit-container--> 
                            <div class="profile-edit-container fl-wrap block_box">
                                <div class="custom-form" >
                                    <div class="row">
                                        
                                        <div class="clearfix"></div>
                                        <label>Change Avatar</label> 
                                        <div class="clearfix"></div>
                                        <div class="listsearch-input-item fl-wrap">
                                            <div class="fuzone" id="imgProfileField">
                                                
                                                <div class="fu-text">
                                                    <span><i class="fal fa-images"></i> Click here or drop files to upload</span>
                                                    <div class="photoUpload-files fl-wrap"></div>
                                                </div>
                                                <input type="file" id="logo"  class="upload" multiple>
                                                
                                            </div>
                                        </div>

                                        <div class="col-sm-6">
                                            <label>NOM <i class="fal fa-user"></i></label>
                                            <input type="text" name="nom"  placeholder="{{$donnee['professionel']['nom']}}" value="{{$donnee['professionel']['nom']}}"/>                                                
                                        </div>
                                        <div class="col-sm-6">
                                            <label>PRENOM <i class="fal fa-user"></i></label>
                                            <input type="text" name="prenom"  placeholder="{{$donnee['professionel']['prenom']}}" value="{{$donnee['professionel']['prenom']}}"/>                                                
                                        </div>
                                        <div class="col-sm-6">
                                            <label> Adresse Email <i class="far fa-envelope"></i>  </label>
                                            <input type="text" name="email"  placeholder="{{$donnee['professionel']['email']}}" value="{{$donnee['professionel']['email']}}"/>                                                
                                        </div>
                                        <div class="col-sm-6">
                                            <label>Numero 1<i class="far fa-phone"></i>  </label>
                                            <input type="text" name="tel1"  placeholder="{{$donnee['telephone'][0]['numero1']}}" value="{{$donnee['telephone'][0]['numero1']}}"/>                                                
                                        </div>
                                        <div class="col-sm-6">
                                            <label>Ville<i class="far fa-phone"></i>  </label>
                                            <select id="secteur"  name="ville" class="secteur select" >
                                                    
                                            </select>                                               
                                        </div>
                                        <div class="col-sm-6">
                                            <label> Adresse <i class="fas fa-map-marker"></i>  </label>
                                            <input type="text" name="adresse"  placeholder="{{$donnee['professionel']['Adresse']}}" value="{{$donnee['professionel']['Adresse']}}"/>                                                
                                        </div>
                                        <div class="col-sm-6">
                                            <label>Numero 2<i class="far fa-phone"></i>  </label>
                                            <input type="text" name="tel2"  placeholder="{{$donnee['telephone'][0]['numero2']}}" value="{{$donnee['telephone'][0]['numero2']}}"/>                                                
                                        </div>
                                        <div class="col-sm-6">
                                            <label> Website <i class="far fa-globe"></i>  </label>
                                            <input type="text" name="website"  placeholder="themeforest.net" value="themeforest.net"/>                                                
                                        </div>
                                        <div class="col-sm-6">
                                            <label>Numero 3<i class="far fa-phone"></i>  </label>
                                            <input type="text" name="tel3"  placeholder="{{$donnee['telephone'][0]['numero3']}}" value="{{$donnee['telephone'][0]['numero3']}}"/>                                                
                                        </div>
                                    </div>
                                    <label> Description</label>                                              
                                    <textarea cols="40" rows="3" name="description"  placeholder="{{$donnee['professionel']['description']}}" style="margin-bottom:20px;">{{$donnee['professionel']['description']}}</textarea>
                                    
                                </div>
                            </div>


                            <!-- profile-edit-container end-->                                      
                            <div class="dashboard-title  dt-inbox fl-wrap">
                                <h3>Gallery</h3>
                            </div>
                            <!-- profile-edit-container--> 
                            <div class="profile-edit-container fl-wrap block_box">
                                <div class="custom-form">
                                    <div class="row">
                                        <?php $i1 = 0; ?>
                                        @foreach ($donnee['galerie'] as $galery)
                                            <?php $i1++?>
                                            <div class="col-md-4"> 
                                                <div class="act-widget fl-wrap">
                                                    <div class="add-list-media-wrap" id="noimg" hidden=''>
                                                        <div class="listsearch-input-item fl-wrap">
                                                            <div class="fuzone">
                                                                <div class="fu-text">
                                                                    <span><i class="fal fa-images"></i> Click here or drop files to upload</span>
                                                                    <div class="photoUpload-files fl-wrap"></div>
                                                                </div>
                                                                <input type="file" class="upload" onchange="galerySetimgfunction(this)" multiple>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div id="yesimg" >
                                                        <div class="fuzone">
                                                            <img src="{{ $apiAddress.''.$galery['url'] }}" height="120" width="100%" alt="" data-id="{{$galery['id']}}">
                                                        </div>
                                                        <span id="imgbtn" onclick="galeryDeleteimgfunction(this)" style="background: red; padding: 5px; width:100%; margin-top:0px;">delete</span>
                                                    </div>
                                                </div>
                                            </div>
                                        @endforeach

                                        @if ($i1 < 6)
                                            <?php $i2 = 6-$i1 ?>
                                            @for ($i =0; $i < $i2; $i++)

                                                <div class="col-md-4"> 
                                                    <div class="act-widget fl-wrap">
                                                        <div class="add-list-media-wrap" id="noimg" >
                                                            <div class="listsearch-input-item fl-wrap">
                                                                <div class="fuzone">
                                                                    <div class="fu-text">
                                                                        <span><i class="fal fa-images"></i> Click here or drop files to upload</span>
                                                                        <div class="photoUpload-files fl-wrap"></div>
                                                                    </div>
                                                                    <input type="file" class="upload"  onchange="galerySetimgfunction(this)" multiple>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div id="yesimg" hidden=''>
                                                            <div class="fuzone">
                                                                <img src="" height="120" width="100%" alt="" data-id="">
                                                            </div>
                                                            <span id="imgbtn" onclick="galeryDeleteimgfunction(this)" style="background: red; padding: 5px; width:100%; margin-top:0px;">delete</span>
                                                        </div>
                                                    </div>
                                                </div>

                                            @endfor

                                        @endif
                                        
                                    </div>
                                </div>
                            </div>
                            <!-- profile-edit-container end--> 


                            <!-- profile-edit-container end--> 
                            <div class="dashboard-title dt-inbox fl-wrap">
                                <h3>Your  Socials</h3>
                            </div>
                            <!-- profile-edit-container--> 
                            <div class="profile-edit-container fl-wrap block_box">
                                <div class="custom-form">
                                    <label>Facebook <i class="fab fa-facebook"></i></label>
                                    <input type="text" name="facebook"  placeholder="https://www.facebook.com/" value="https://www.facebook.com/"/>
                                    <label>Twitter<i class="fab fa-twitter"></i>  </label>
                                    <input type="text" name="twitter"  placeholder="https://twitter.com/" value="https://twitter.com/"/>
                                    <label>Vkontakte<i class="fab fa-vk"></i>  </label>
                                    <input type="text" name="vk"  placeholder="https://vk.com" value="https://vk.com"/>
                                    <label> Instagram <i class="fab fa-instagram"></i>  </label>
                                    <input type="text" name="instagram"  placeholder="https://www.instagram.com/" value="https://www.instagram.com/"/>
                                    <button class="btn    color2-bg  float-btn">Save Changes<i class="fal fa-save"></i></button>
                                </div>
                            </div>
                            <!-- profile-edit-container end-->       
                        </form>                             
                    </div>
                    <!-- dashboard content end-->
                </div>
            </section>
            <!--  section  end-->
            <div class="limit-box fl-wrap"></div>
        </div>
        <!--content end-->
    </div>
    <!-- wrapper end-->
@endsection

@section('script')
    <!--=============== scripts  ===============-->
    <script src="{{asset('js/jquery.min.js')}}"></script>
    <script src="{{asset('js/plugins.js')}}"></script>
    <script src="{{asset('js/scripts.js')}}"></script>

    <script>
        var donnee = {!! json_encode($donnee) !!};
        var apiAddress = {!! json_encode($apiAddress) !!}

        fetch(`${apiAddress}/api/ville`)
        .then(function(response) {
            return response.json();
        })
        .then(function(data) {
            var mainContainer = document.getElementById("ville");
            //var div = document.createElement("option");
            //console.log(data);
            mainContainer.innerHTML = '';
            mainContainer.innerHTML += "<option disabled > Ville </option>";
            for (var i = 0; i < data.length; i++) {
                if(donnee['societe']['villes_id'] == data[i].id){
                    mainContainer.innerHTML += '<option selected value="' + data[i].id + '" data-icon=" " data-tokens="'+ data[i].libelle +'">' + data[i].libelle + '</option>';
                }else{
                    mainContainer.innerHTML += '<option value="' + data[i].id + '" data-icon=" " data-tokens="'+ data[i].libelle +'">' + data[i].libelle + '</option>';
                }
                
                // div.innerHTML = '<option value="' + data[i].id + '">' + data[i].libelle + '</option>';
                // mainContainer.appendChild(div); <option data-icon="glyphicon-heart" data-tokens="ketchup mustard">Hot Dog, Fries and a Soda</option>
            }
            ssecteur()
           
        })
        .catch(function(err) {
            console.log('error: ' + err);
        });

        const formData = new FormData();
        const handleSubmit = (event) => {
            const inputFile = document.getElementById("logo");
            const formData = new FormData();
            event.preventDefault();

            for (const file of inputFile.files) {
                formData.append("logo", file);
            }

            console.log(inputFile.files);

            formData.append("pro", donnee['professionel']['id'])

           /*fetch(`${apiAddress}/api/societe/update/change_logo`, {
                method: "post",
                body: formData,
            }).then(function(response) {
                return response.json();
            })
            .then(function(data) {
                console.log(data)
                imgdivfunction(data);
                console.log('OK OK OK')

            })
            .catch((error) => ("Something went wrong!", error));*/
        };
        document.getElementById("logo").addEventListener("change", handleSubmit);

        function imgdivfunction(url){
            var logoField = document.getElementById('imgProfileField')
            logoField.innerHTML = '';
            logoField.innerHTML = `<div id="imgdiv"><a href="#"><img src="${apiAddress + url}" height="179" width="200" alt=""><div class="inputhidden"><input type="file" id="logo" hidden></div></a></div>`
            const imgdiv = document.querySelector("#imgdiv");
            const adiv = imgdiv.querySelector("a");
            const input = adiv.querySelector("input");

            adiv.addEventListener('click', function(){
                input.click()
            })
            //console.log('ok')
            input.addEventListener("change", handleSubmit)
        }

        if(donnee['profil']){
            //console.log(donnee['profil']['url'])
            imgdivfunction(donnee['profil']['url'])
        }


        function galerySetimgfunction(element){
            const  fuzone = element.parentNode;
            const listsearch = fuzone.parentNode;
            const addlist = listsearch.parentNode;

            const maindiv = addlist.parentNode;

            const imgmaindiv = maindiv.querySelector('#yesimg');
            const imgdiv = imgmaindiv.querySelector('.fuzone');
            const img = maindiv.querySelector('img');

            //var galery = fuzone.document.getElementById("galery");

            const formData = new FormData();
            //console.log(element.files);

            for (const file of element.files) {
                formData.append("image", file);
            }

            formData.append("pro", donnee['professionel']['id'])

            fetch(`${apiAddress}/api/societe/update/addgalerie`, {
                method: "post",
                body: formData,
            }).then(function(response) {
                return response.json();
            })
            .then(function(data) {
                console.log(data)
                img.setAttribute('src',`${apiAddress + data[0]}`)
                img.setAttribute('data-id',`${data[1]}`)
                addlist.setAttribute('hidden','')
                imgmaindiv.removeAttribute('hidden')
            })
            .catch((error) => ("Something went wrong!", error));


        }

        function galeryDeleteimgfunction(element){
            const  imgdiv = element.parentNode;
            const maindiv = imgdiv.parentNode;

            const imgmaindiv = imgdiv.querySelector('.fuzone')
            const img = imgmaindiv.querySelector('img')
            var imgid = img.getAttribute('data-id') 
            console.log(imgid)

            //console.log(formData)

            fetch(`${apiAddress}/api/societe/update/galerie/delete`, {
                method: "delete",
                headers: {
                    Accept: 'application/json',
                    'Content-Type': 'application/json'
                },
                body: JSON.stringify({
                    imgid: imgid,
                })
            }).then(function(response) {
                return response.json();
            })
            .then(function(data) {
                console.log(data)
                imgdiv.setAttribute('hidden','')
                maindiv.querySelector('#noimg').removeAttribute('hidden')
            })
            .catch((error) => ("Something went wrong!", error));

            
        }

    </script>

@endsection