@extends('layouts.main')

@section('extra-css')
    <link type="text/css" rel="stylesheet" href="{{ asset('css/dashboard-style.css') }}">
    <meta name="csrf-token" content="{{ csrf_token() }}">
@endsection

@section('content')
    <!-- wrapper-->
    <div id="wrapper">
        <!-- content-->
        <div class="content">
            
            <!--  section  -->
            <section class="gray-bg main-dashboard-sec" id="sec1">
                <div class="container">
                   
                    <!-- dashboard content-->
                    <div class="col-md-9">
                        <div class="dashboard-title   fl-wrap">
                            <h3>Change Password</h3>
                        </div>
                        <!-- profile-edit-container--> 
                        <div class="profile-edit-container fl-wrap block_box">
                            <form id="form">

                                <div class="custom-form">
                                    <div class="pass-input-wrap fl-wrap">
                                
                                        <input type="token" class="" name="token"  placeholder="" value="{{ $token }}" hidden/>
                                    </div>
                                    <div class="pass-input-wrap fl-wrap">
                                        <label>New Password</label>
                                        <input type="password" name="password" class="pass-input" placeholder="" value=""/>
                                        <span class="eye"><i class="far fa-eye" aria-hidden="true"></i> </span>
                                    </div>
                                
                                    <a class="btn  color2-bg  float-btn" id="submitForm">Save Changes<i class="fal fa-save"></i></a>
                                </div>
                            </form>
                        </div>
                        <!-- profile-edit-container end-->                                    
                    </div>
                    <!-- dashboard content end-->
                </div>
            </section>
            <!--  section  end-->
            <div class="limit-box fl-wrap"></div>
        </div>
        <!--content end-->
    </div>
    <!-- wrapper end-->
@endsection

@section('script')
<script src="{{asset('js/jquery.min.js')}}"></script>
<script src="{{asset('js/plugins.js')}}"></script>
<script src="{{asset('js/scripts.js')}}"></script>
<script>
    document.getElementById('submitForm').addEventListener("click", function(){
        var forms = document.getElementById('form');
        var data = new FormData(forms)
        const value = Object.fromEntries(data.entries());
        console.log(value );
        fetch(`${apiAddress}/api/auth/update_password`, {
            method: 'POST',
            headers: {
                Accept: 'application/json',
                'Content-Type': 'application/json'
            },
            body: JSON.stringify({
                token: value['token'],
                password: value['password'],
            })
        }).then(function(response) {
            return response.json();
        })
        .then(function(data) {
            console.log(data)
            //imgdivfunction(data);

        })
        .catch((error) => ("Something went wrong!", error));
    });
</script>
@endsection