<!DOCTYPE HTML>

<html lang="en">

    <head>

        <!--=============== basic  ===============-->

        <meta charset="UTF-8">

        <title>AfroBase le repertoire des sociétés et des professionnels d'Afrique</title>

        <meta name="viewport" content="width=device-width, initial-scale=1.0, minimum-scale=1.0, maximum-scale=1.0, user-scalable=no">

        <meta name="robots" content="index, follow"/>

        <meta name="keywords" content=""/>

        <meta name="description" content=""/>

        <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

        <!--=============== css  ===============-->	

        <link type="text/css" rel="stylesheet" href="<?php echo e(asset('css/reset.css')); ?>">

        <link type="text/css" rel="stylesheet" href="<?php echo e(asset('css/plugins.css')); ?>">

        <link type="text/css" rel="stylesheet" href="<?php echo e(asset('css/style.css')); ?>">

        <link type="text/css" rel="stylesheet" href="<?php echo e(asset('css/color.css')); ?>">

        <?php echo $__env->yieldContent('extra-css'); ?>

        <!--=============== favicons ===============-->

        <link rel="shortcut icon" href="<?php echo e(asset('images/icone.ico')); ?>">

        <style>

            .search-input input{

            /*height: 55px;

            width: 100%;

            outline: none;

            border: none;

            border-radius: 5px;

            padding: 0 60px 0 20px;

            font-size: 18px;

            box-shadow: 0px 1px 5px rgba(0,0,0,0.1);*/

            }



            .search-input.active input{

            border-radius: 5px 5px 0 0;

            }



            .search-input .autocom-box{

            padding: 0;

            opacity: 0;

            pointer-events: none;

            max-height: 280px;

            overflow-y: auto;

            }



            .search-input.active .autocom-box{

            padding: 10px 8px;

            opacity: 1;

            pointer-events: auto;

            }



            .autocom-box li{

            list-style: none;

            padding: 8px 12px;

            display: none;

            width: 100%;

            cursor: default;

            border-radius: 3px;

            }



            .search-input.active .autocom-box li{

            display: block;

            }

            .autocom-box li:hover{

            background: #efefef;

            }



            .search-input .icon{

            position: absolute;

            right: 0px;

            top: 0px;

            height: 55px;

            width: 55px;

            text-align: center;

            line-height: 55px;

            font-size: 20px;

            color: #644bff;

            cursor: pointer;

            }

        </style>

    </head>

    <body>



        <!--loader-->

        <div class="loader-wrap">

            <div class="loader-inner">

                <div class="loader-inner-cirle"></div>

            </div>

        </div>

        <!--loader end-->

        <!-- main start  -->

        <div id="main">

            <!-- header -->

            <header class="main-header">

                <!-- logo-->

                <a href="/" class="logo-holder"><img src="<?php echo e(asset('images/logo.png')); ?>" alt=""></a>

                <!-- logo end-->



                <div class="header-search_btn show-search-button"><i class="fal fa-search"></i><span>recherche</span></div>

                

                <?php if(session()->get('user') == null): ?>

                    <div class="show-reg-form modal-open avatar-img" data-srcav="images/avatar/3.jpg"><i class="fal fa-user"></i>Sign In</div>

                <?php else: ?>

                <a href="/auth/logout"><div class="show-reg-form " data-srcav="images/avatar/3.jpg"><i class="fal fa-user"></i>Logout</div></a>

                <a href="/dashboard"><div class="show-reg-form " data-srcav="images/avatar/3.jpg"><i class="fal fa-chart-line"></i>Dashboard</div></a>

                    

                <?php endif; ?>

                

                <!-- header opt end--> 

                <!-- lang-wrap-->

                <div class="lang-wrap">

                    <!--<div class="show-lang"><span><i class="fal fa-globe-europe"></i><strong>En</strong></span><i class="fa fa-caret-down arrlan"></i></div>-->

                    <!--<ul class="lang-tooltip lang-action no-list-style">

                        <li><a href="#" class="current-lan" data-lantext="En">English</a></li>

                        <li><a href="#" data-lantext="Fr">Français</a></li>

                        <li><a href="#" data-lantext="Es">Español</a></li>

                        <li><a href="#" data-lantext="De">Deutsch</a></li>

                    </ul>-->

                </div>

                <!-- lang-wrap end-->                                 

                <!-- nav-button-wrap--> 

                <div class="nav-button-wrap color-bg">

                    <div class="nav-button">

                        <span></span><span></span><span></span>

                    </div>

                </div>

                <!-- nav-button-wrap end-->

                <!--  navigation --> 

                <div class="nav-holder main-menu">

                    <nav>

                        <ul class="no-list-style">



                            <li>

                                <a href="#" id="myBtn" > <img src="<?php echo e(asset('images/PAYS_AFR/'.session()->get('paysUrl'))); ?>" alt="" width="35px">   </a>

                                <ul>

                                    <li>

                                        <table style="overflow-y:scroll; height:300px; display:block; width: 250px;">

                                            

                                                <tr>



                                                    <td><a   href="/setchosepays/ / /afrique.png"> <img src="<?php echo e(asset('images/PAYS_AFR/afrique.png')); ?>" alt="" width="35px"> Toute l'Afrique</a></td>

                                                </tr>



                                                <th>



                                                <tr>



                                                    <td><a   href="/setchosepays/Algeria/afr1/Algeria.png"><img src="<?php echo e(asset('images/PAYS_AFR/Algeria.png')); ?>" alt="" width="35px"> Algeria</a></td>

                                                </tr>



                                                <tr>



                                                    <td ><a   href="/setchosepays/Angola/afr2/Angola.png"><img src="<?php echo e(asset('images/PAYS_AFR/Angola.png')); ?>" alt="" width="35px"> Angola</a></td>

                                                </tr>



                                                <tr>



                                                    <td ><a   href="/setchosepays/Benin/afr3/Benin.jpg"><img src="<?php echo e(asset('images/PAYS_AFR/Benin.jpg')); ?>" alt="" width="35px"> Benin</a></td>

                                                </tr>



                                                <tr>



                                                    <td class="afr4"><a   href="/setchosepays/Botswana/afr4/Botswana.png"><img src="<?php echo e(asset('images/PAYS_AFR/Botswana.png')); ?>" alt="" width="35px"> Botswana</a></td>

                                                </tr>



                                                <tr>



                                                    <td class="afr5"><a   href="/setchosepays/Burkina Faso/afr5/Burkina.png"><img src="<?php echo e(asset('images/PAYS_AFR/Burkina.png')); ?>" alt="" width="35px"> Burkina Faso</a></td>

                                                </tr>



                                                <tr>



                                                    <td class="afr6"><a   href="/setchosepays/Burundi/afr6/Burundi.png"><img src="<?php echo e(asset('images/PAYS_AFR/Burundi.png')); ?>" alt="" width="35px"> Burundi</a></td>

                                                </tr>



                                                <tr>



                                                    <td class="afr7"><a   href="/setchosepays/Cameroon/afr7/Cameroon.png"><img src="<?php echo e(asset('images/PAYS_AFR/Cameroon.png')); ?>" alt="" width="35px"> Cameroon</a></td>

                                                </tr>



                                                <tr>



                                                    <td class="afr8"><a   href="/setchosepays/Cape Verde/afr8/Cape Verde.png" class="tooltip-middle"><img src="<?php echo e(asset('images/PAYS_AFR/Cape Verde.png')); ?>" alt="" width="35px"> Cape Verde <small>(Portugal)</small></a></td>

                                                </tr>



                                                <tr>



                                                    <td class="afr9"><a   href="/setchosepays/Canary Islands/afr9/Canary Islands.png" class="tooltip-middle"><img src="<?php echo e(asset('images/PAYS_AFR/Canary Islands.png')); ?>" alt="" width="35px"> Canary Islands <small>(Spain)</small></a></td>

                                                </tr>



                                                <tr>

                                                    <td class="afr10"><a   href="/setchosepays/Central African Republic/afr10/Central African Republic.png"><img src="<?php echo e(asset('images/PAYS_AFR/Central African Republic.png')); ?>" alt="" width="35px"> Central African Republic</a></td>

                                                </tr>



                                                <tr>



                                                    <td class="afr11"><a   href="/setchosepays/Chad/afr11/Chad.png"><img src="<?php echo e(asset('images/PAYS_AFR/Chad.png')); ?>" alt="" width="35px"> Chad</a></td>

                                                </tr>



                                                <tr>



                                                    <td class="afr12"><a   href="/setchosepays/Comoros/afr12/Comoros.png" class="tooltip-middle"><img src="<?php echo e(asset('images/PAYS_AFR/Comoros.png')); ?>" alt="" width="35px"> Comoros</a></td>

                                                </tr>



                                                <tr>



                                                    <td class="afr13"><a   href="/setchosepays/Congo/afr13/Congo.png"><img src="<?php echo e(asset('images/PAYS_AFR/Congo.png')); ?>" alt="" width="35px"> Congo</a></td>

                                                </tr>



                                                <tr>



                                                    <td class="afr14"><a   href="/setchosepays/Côte d'Ivoire/afr14/Côte d'Ivoire.png"><img src="<?php echo e(asset("images/PAYS_AFR/Côte d'Ivoire.png")); ?>" alt="" width="35px"> Côte d'Ivoire</a></td>

                                                </tr>



                                                <tr>



                                                    <td class="afr15"><a   href="/setchosepays/Democratic Repubtdc of the Congo/afr15/Democratic Republic of the Congo.png"><img src="<?php echo e(asset('images/PAYS_AFR/Democratic Republic of the Congo.png')); ?>" alt="" width="35px"> Democratic Republic of the Congo</a></td>

                                                </tr>



                                                <tr>



                                                    <td class="afr16"><a   href="/setchosepays/Djibouti/afr16/Djibouti.png"><img src="<?php echo e(asset('images/PAYS_AFR/Djibouti.png')); ?>" alt="" width="35px"> Djibouti</a></td>

                                                </tr>



                                                <tr>



                                                    <td class="afr17"><a   href="/setchosepays/Egypt/afr17/Egypt.png"><img src="<?php echo e(asset('images/PAYS_AFR/Egypt.png')); ?>" alt="" width="35px"> Egypt</a></td>

                                                </tr>



                                                <tr>



                                                    <td class="afr18"><a   href="/setchosepays/Equatorial Guinea/afr18/Equatorial Guinea.png"><img src="<?php echo e(asset('images/PAYS_AFR/Equatorial Guinea.png')); ?>" alt="" width="35px"> Equatorial Guinea</a></td>

                                                </tr>



                                                <tr>



                                                    <td class="afr19"><a   href="/setchosepays/Eritrea/afr19/Eritrea.png"><img src="<?php echo e(asset('images/PAYS_AFR/Eritrea.png')); ?>" alt="" width="35px"> Eritrea</a></td>



                                                    

                                                </tr>



                                                <tr>

                                                    <td class="afr20"><a   href="/setchosepays/Ethiopia/afr20/Ethiopia.png"><img src="<?php echo e(asset('images/PAYS_AFR/Ethiopia.png')); ?>" alt="" width="35px"> Ethiopia</a></td>

                                                </tr>



                                                <tr>



                                                    <td class="afr21"><a   href="/setchosepays/Gabon/afr21/Gabon.png"><img src="<?php echo e(asset('images/PAYS_AFR/Gabon.png')); ?>" alt="" width="35px"> Gabon</a></td>

                                                </tr>



                                                <tr>



                                                    <td class="afr22"><a   href="/setchosepays/Gambia/afr22/Gambia.png"><img src="<?php echo e(asset('images/PAYS_AFR/Gambia.png')); ?>" alt="" width="35px"> Gambia</a></td>

                                                </tr>



                                                <tr>



                                                    <td class="afr23"><a   href="/setchosepays/Ghana/afr23/Ghana.png"><img src="<?php echo e(asset('images/PAYS_AFR/Ghana.png')); ?>" alt="" width="35px"> Ghana</a></td>

                                                </tr>



                                                <tr>



                                                    <td class="afr24"><a   href="/setchosepays/Guinea/afr24/Guinea.png"><img src="<?php echo e(asset('images/PAYS_AFR/Guinea.png')); ?>" alt="" width="35px"> Guinea</a></td>

                                                </tr>



                                                <tr>



                                                    <td class="afr25"><a   href="/setchosepays/Guinea-Bisaau/afr25/Guinea-Bisaau.png"><img src="<?php echo e(asset('images/PAYS_AFR/Guinea-Bisaau.png')); ?>" alt="" width="35px"> Guinea-Bisaau</a></td>

                                                </tr>



                                                <tr>



                                                    <td class="afr26"><a   href="/setchosepays/Kenya/afr26/Kenya.png"><img src="<?php echo e(asset('images/PAYS_AFR/Kenya.png')); ?>" alt="" width="35px"> Kenya</a></td>

                                                </tr>



                                                <tr>



                                                    <td class="afr27"><a   href="/setchosepays/Lesotho/afr27/Lesotho.png"><img src="<?php echo e(asset('images/PAYS_AFR/Lesotho.png')); ?>" alt="" width="35px"> Lesotho</a></td>

                                                </tr>



                                                <tr>



                                                    <td class="afr28"><a   href="/setchosepays/Liberia/afr28/Liberia.png"><img src="<?php echo e(asset('images/PAYS_AFR/Liberia.png')); ?>" alt="" width="35px"> Liberia</a></td>

                                                </tr>



                                                <tr>



                                                    <td class="afr29"><a   href="/setchosepays/Libya/afr29/Libya.png"><img src="<?php echo e(asset('images/PAYS_AFR/Libya.png')); ?>" alt="" width="35px"> Libya</a></td>

                                                    

                                                </tr>



                                                <tr>

                                                    <td class="afr30"><a   href="/setchosepays/Madagascar/afr30/Madagascar.png"><img src="<?php echo e(asset('images/PAYS_AFR/Madagascar.png')); ?>" alt="" width="35px"> Madagascar</a></td>

                                                </tr>



                                                <tr>



                                                    <td class="afr31"><a   href="/setchosepays/Madeira/afr31/Madeira.png" class="tooltip-middle"><img src="<?php echo e(asset('images/PAYS_AFR/Madeira.png')); ?>" alt="" width="35px"> Madeira <small>(Portugal)</small></a></td>

                                                </tr>



                                                <tr>



                                                    <td class="afr32"><a   href="/setchosepays/Malawi/afr32/Malawi.png"><img src="<?php echo e(asset('images/PAYS_AFR/Malawi.png')); ?>" alt="" width="35px"> Malawi</a></td>

                                                </tr>



                                                <tr>



                                                    <td class="afr33"><a   href="/setchosepays/Mali/afr33/Mali.png"><img src="<?php echo e(asset('images/PAYS_AFR/Mali.png')); ?>" alt="" width="35px"> Mali</a></td>

                                                </tr>



                                                <tr>



                                                    <td class="afr34"><a   href="/setchosepays/Mauritania/afr34/Mauritania.png"><img src="<?php echo e(asset('images/PAYS_AFR/Mauritania.png')); ?>" alt="" width="35px"> Mauritania</a></td>

                                                </tr>



                                                <tr>



                                                    <td class="afr35"><a   href="/setchosepays/Mauritius/afr35/Mauritius.png"><img src="<?php echo e(asset('images/PAYS_AFR/Mauritius.png')); ?>" alt="" width="35px"> Mauritius</a></td>

                                                </tr>



                                                <tr>



                                                    <td class="afr36"><a   href="/setchosepays/Mayotte/afr36/Mayotte.png"><img src="<?php echo e(asset('images/PAYS_AFR/Mayotte.png')); ?>" alt="" width="35px"> Mayotte <small>(France)</small></a></td>

                                                </tr>



                                                <tr>



                                                    <td class="afr37"><a   href="/setchosepays/Morocco/afr37/Morocco.png"><img src="<?php echo e(asset('images/PAYS_AFR/Morocco.png')); ?>" alt="" width="35px"> Morocco</a></td>

                                                </tr>



                                                <tr>



                                                    <td class="afr38"><a   href="/setchosepays/Mozambique/afr38/Mozambique.png"><img src="<?php echo e(asset('images/PAYS_AFR/Mozambique.png')); ?>" alt="" width="35px"> Mozambique</a></td>

                                                </tr>



                                                <tr>



                                                    <td class="afr39"><a   href="/setchosepays/Namibia/afr39/Namibia.png"><img src="<?php echo e(asset('images/PAYS_AFR/Namibia.png')); ?>" alt="" width="35px"> Namibia</a></td>



                                                </tr>

                                                <tr>

                                                    <td class="afr40"><a   href="/setchosepays/Niger/afr40/Niger.png"><img src="<?php echo e(asset('images/PAYS_AFR/Niger.png')); ?>" alt="" width="35px"> Niger</a></td>

                                                </tr>



                                                <tr>



                                                    <td class="afr41"><a   href="/setchosepays/Nigeria/afr41/Nigeria.png"><img src="<?php echo e(asset('images/PAYS_AFR/Nigeria.png')); ?>" alt="" width="35px"> Nigeria</a></td>

                                                </tr>



                                                <tr>



                                                    <td class="afr42"><a   href="/setchosepays/Réunion/afr42/Réunion.png"><img src="<?php echo e(asset('images/PAYS_AFR/Réunion.png')); ?>" alt="" width="35px"> Réunion <small>(France)</small></a></td>

                                                </tr>



                                                <tr>



                                                    <td class="afr43"><a   href="/setchosepays/Rwanda/afr43/Rwanda.png"><img src="<?php echo e(asset('images/PAYS_AFR/Rwanda.png')); ?>" alt="" width="35px"> Rwanda</a></td>

                                                </tr>



                                                <tr>



                                                    <td class="afr44"><a   href="/setchosepays/Sahrawi Arab Democratic Republic/afr44/Sahrawi Arab Democratic Republic.png"><img src="<?php echo e(asset('images/PAYS_AFR/Sahrawi Arab Democratic Republic.png')); ?>" alt="" width="35px"> Sahrawi Arab Democratic Republic</a></td>

                                                </tr>



                                                <tr>



                                                    <td class="afr45"><a   href="/setchosepays/São Tomé and Príncipe/afr45/Sao Tomé and Príncipe.png"  class="tooltip-middle"><img src="<?php echo e(asset('images/PAYS_AFR/Sao Tomé and Príncipe.png')); ?>" alt="" width="35px"> São Tomé and Príncipe</a></td>

                                                </tr>



                                                <tr>



                                                    <td class="afr46"><a   href="/setchosepays/Senegal/afr46/Senegal.png"><img src="<?php echo e(asset('images/PAYS_AFR/Senegal.png')); ?>" alt="" width="35px"> Senegal</a></td>

                                                </tr>



                                                <tr>



                                                    <td class="afr47"><a   href="/setchosepays/Seychelles/afr47/Seychelles.png"  class="tooltip-middle"><img src="<?php echo e(asset('images/PAYS_AFR/Seychelles.png')); ?>" alt="" width="35px"> Seychelles</a></td>

                                                </tr>



                                                <tr>



                                                    <td class="afr48"><a   href="/setchosepays/Sierra Leone/afr48/Sierra Leone.png"><img src="<?php echo e(asset('images/PAYS_AFR/Sierra Leone.png')); ?>" alt="" width="35px"> Sierra Leone</a></td>



                                                </tr>



                                                <tr>



                                                    <td class="afr49"><a   href="/setchosepays/Somalia/afr49/Somalia.png"><img src="<?php echo e(asset('images/PAYS_AFR/Somalia.png')); ?>" alt="" width="35px"> Somalia</a></td>

                                                </tr>



                                                

                                                <tr>

                                                    <td class="afr50"><a   href="/setchosepays/Somaliland/afr50/Somaliland.png"><img src="<?php echo e(asset('images/PAYS_AFR/Somaliland.png')); ?>" alt="" width="35px"> Somaliland</a></td>

                                                </tr>



                                                <tr>



                                                    <td class="afr51"><a   href="/setchosepays/South Africa/afr51/South Africa.png"><img src="<?php echo e(asset('images/PAYS_AFR/South Africa.png')); ?>" alt="" width="35px"> South Africa</a></td>

                                                </tr>



                                                <tr>



                                                    <td class="afr52"><a   href="/setchosepays/South Sudan/afr52/South Sudan.png"><img src="<?php echo e(asset('images/PAYS_AFR/South Sudan.png')); ?>" alt="" width="35px"> South Sudan</a></td>

                                                </tr>



                                                <tr>



                                                    <td class="afr53"><a   href="/setchosepays/Sudan/afr53/Sudan.png"><img src="<?php echo e(asset('images/PAYS_AFR/Sudan.png')); ?>" alt="" width="35px"> Sudan</a></td>

                                                </tr>



                                                <tr>



                                                    <td class="afr54"><a   href="/setchosepays/Swaziland/afr54/Swaziland.png"><img src="<?php echo e(asset('images/PAYS_AFR/Swaziland.png')); ?>" alt="" width="35px"> Swaziland</a></td>

                                                </tr>



                                                <tr>



                                                    <td class="afr55"><a   href="/setchosepays/Togo/afr55/Togo.png"><img src="<?php echo e(asset('images/PAYS_AFR/Togo.png')); ?>" alt="" width="35px"> Togo</a></td>

                                                </tr>



                                                <tr>



                                                    <td class="afr56"><a   href="/setchosepays/Tunisia/afr56/Tunisia.png"><img src="<?php echo e(asset('images/PAYS_AFR/Tunisia.png')); ?>" alt="" width="35px"> Tunisia</a></td>

                                                </tr>



                                                <tr>



                                                    <td class="afr57"><a   href="/setchosepays/Uganda/afr57/Uganda.png"><img src="<?php echo e(asset('images/PAYS_AFR/Uganda.png')); ?>" alt="" width="35px"> Uganda</a></td>

                                                </tr>



                                                <tr>



                                                    <td class="afr58"><a   href="/setchosepays/United Republic of Tanzania/afr58/United Republic of Tanzania.png"><img src="<?php echo e(asset('images/PAYS_AFR/United Republic of Tanzania.png')); ?>" alt="" width="35px"> United Republic of Tanzania</a></td>

                                                </tr>



                                                <tr>



                                                    <td class="afr59"><a   href="/setchosepays/Zambia/afr59/Zambia.png"><img src="<?php echo e(asset('images/PAYS_AFR/Zambia.png')); ?>" alt="" width="35px"> Zambia</a></td>



                                                </tr>

                                                <tr>

                                                    <td class="afr60"><a    href="/setchosepays/Zimbabwe/afr60/Zimbabwe.png"><img src="<?php echo e(asset('images/PAYS_AFR/Zimbabwe.png')); ?>" alt="" width="35px"> Zimbabwe</a></td>

                                                </tr>

                                            

                                        </table>

                                    </li>

                                </ul>

                            </li>



                            <li>

                                <a href="/all/societe" class="act-link">ENTREPRISES <!-- <i class="fa fa-caret-down"></i>--></a>

                            </li>



                            <li>

                                <a href="/professionel/getall">PROFESSIONNELS </a>

                            </li>

                            

                            <li>

                                <a href="/services">SERVICES </a>

                            </li>



                            <!--<li>

                                <a href="/foire_d_afrique" >Foire d'Afrique PARIS</a>

                            </li>-->



                            <!--<li>

                                <a href="/allannonce">ANNONCES </a>

                            </li>

                            <li>

                                <a href="#">NEWS </a>

                            </li>-->



                        </ul>

                    </nav>

                </div>

                <!-- navigation  end -->

                <!-- header-search_container -->                     

                <div class="header-search_container header-search vis-search">

                    <div class="container small-container">

                        <form action="/listing-Societe" method="post">

                            <?php echo csrf_field(); ?>

                            <div class="main-search-input fl-wrap">

                                <div class="main-search-input-item search-input search-input-societe" style="">

                                    <label><i class="fal fa-keyboard"></i></label>

                                    <input type="text" name="word" placeholder="Que cherchez-vous?" value=""/>

                                    <div class="autocom-box" style="background: white">

                                        <!-- here list are inserted from javascript -->

                                    </div>

                                </div>

                                <div class="main-search-input-item location search-input search-input-ville">

                                    <label><i class="fal fa-map-marker-check"></i></label>

                                    <input type="text" name="ville" placeholder="Emplacement"  value=""/>

                                    <div class="autocom-box" style="background: white">

                                        <!-- here list are inserted from javascript -->

                                    </div>

                                    <a href="#"><i class="fa fa-dot-circle-o"></i></a>

                                </div>

                                <div class="main-search-input-item">

                                    <select data-placeholder="Categories" name="secteur" id="secteur"  class="nice-select" >

                                        <option>All Categories</option>

                                        <option>Shops</option>

                                        <option>Hotels</option>

                                        <option>Restaurants</option>

                                        <option>Fitness</option>

                                        <option>Events</option>

                                    </select>

                                </div>

                                <button type="submit" class="main-search-button color2-bg" >Chercher <i class="far fa-search"></i></button>

                            </div>

                        </form>

                        <div class="header-search_close color-bg"><i class="fal fa-long-arrow-up"></i></div>

                    </div>

                </div>

                <!-- header-search_container  end --> 

                <!-- wishlist-wrap--> 

                <div class="header-modal novis_wishlist">

                    <!-- header-modal-container--> 

                    <div class="header-modal-container scrollbar-inner fl-wrap" data-simplebar>

                        <!--widget-posts-->

                        <div class="widget-posts  fl-wrap">

                            <ul class="no-list-style">

                                <li>

                                    <div class="widget-posts-img"><a href="listing-single.html"><img src="<?php echo e(asset('images/gallery/thumbnail/1.png')); ?>" alt=""></a>  

                                    </div>

                                    <div class="widget-posts-descr">

                                        <h4><a href="listing-single.html">Iconic Cafe</a></h4>

                                        <div class="geodir-category-location fl-wrap"><a href="#"><i class="fas fa-map-marker-alt"></i> 40 Journal Square Plaza, NJ, USA</a></div>

                                        <div class="widget-posts-descr-link"><a href="listing.html" >Restaurants </a>   <a href="listing.html">Cafe</a></div>

                                        <div class="widget-posts-descr-score">4.1</div>

                                        <div class="clear-wishlist"><i class="fal fa-times-circle"></i></div>

                                    </div>

                                </li>

                                <li>

                                    <div class="widget-posts-img"><a href="listing-single.html"><img src="<?php echo e(asset('images/gallery/thumbnail/1.png')); ?>" alt=""></a>

                                    </div>

                                    <div class="widget-posts-descr">

                                        <h4><a href="listing-single.html">MontePlaza Hotel</a></h4>

                                        <div class="geodir-category-location fl-wrap"><a href="#"><i class="fas fa-map-marker-alt"></i> 70 Bright St New York, USA </a></div>

                                        <div class="widget-posts-descr-link"><a href="listing.html" >Hotels </a>  </div>

                                        <div class="widget-posts-descr-score">5.0</div>

                                        <div class="clear-wishlist"><i class="fal fa-times-circle"></i></div>

                                    </div>

                                </li>

                                <li>

                                    <div class="widget-posts-img"><a href="listing-single.html"><img src="<?php echo e(asset('images/gallery/thumbnail/1.png')); ?>" alt=""></a>

                                    </div>

                                    <div class="widget-posts-descr">

                                        <h4><a href="listing-single.html">Rocko Band in Marquee Club</a></h4>

                                        <div class="geodir-category-location fl-wrap"><a href="#"><i class="fas fa-map-marker-alt"></i>75 Prince St, NY, USA</a></div>

                                        <div class="widget-posts-descr-link"><a href="listing.html" >Events</a> </div>

                                        <div class="widget-posts-descr-score">4.2</div>

                                        <div class="clear-wishlist"><i class="fal fa-times-circle"></i></div>

                                    </div>

                                </li>

                                <li>

                                    <div class="widget-posts-img"><a href="listing-single.html"><img src="<?php echo e(asset('images/gallery/thumbnail/1.png')); ?>" alt=""></a>

                                    </div>

                                    <div class="widget-posts-descr">

                                        <h4><a href="listing-single.html">Premium Fitness Gym</a></h4>

                                        <div class="geodir-category-location fl-wrap"><a href="#"><i class="fas fa-map-marker-alt"></i> W 85th St, New York, USA</a></div>

                                        <div class="widget-posts-descr-link"><a href="listing.html" >Fitness</a> <a href="listing.html" >Gym</a> </div>

                                        <div class="widget-posts-descr-score">5.0</div>

                                        <div class="clear-wishlist"><i class="fal fa-times-circle"></i></div>

                                    </div>

                                </li>

                            </ul>

                        </div>

                        <!-- widget-posts end-->

                    </div>

                    <!-- header-modal-container end--> 

                    <div class="header-modal-top fl-wrap">

                        <h4>Your Wishlist : <span><strong></strong> Locations</span></h4>

                        <div class="close-header-modal"><i class="far fa-times"></i></div>

                    </div>

                </div>

                <!--wishlist-wrap end --> 

            </header>

            <!-- header end-->



            <?php echo $__env->yieldContent('content'); ?>





            <!--footer -->

            <footer class="main-footer fl-wrap">

                <!-- footer-header-->

                <div class="footer-header fl-wrap grad ient-dark">

                    

                </div>

                <!-- footer-header end-->

                <!--footer-inner-->

                <div class="footer-inner   fl-wrap">

                    <div class="container">

                        <div class="row">

                            <!-- footer-widget-->

                            <div class="col-md-12">

                                <div class="footer-widget fl-wrap">

                                    <div class="footer-logo"><a href="index.html"><img src="<?php echo e(asset('images/logo.png')); ?>" alt=""></a></div>

                                    <div class="footer-contacts-widget fl-wrap">

                                        <p>In ut odio libero, at vulputate urna. Nulla tristique mi a massa convallis cursus. Nulla eu mi magna. Etiam suscipit commodo gravida.   </p>

                                        <ul  class="footer-contacts fl-wrap no-list-style">

                                            <li><span><i class="fal fa-envelope"></i> Mail :</span><a href="#" target="_blank">yourmail@domain.com</a></li>

                                            <li> <span><i class="fal fa-map-marker"></i> Adress :</span><a href="#" target="_blank">USA 27TH Brooklyn NY</a></li>

                                            <li><span><i class="fal fa-phone"></i> Phone :</span><a href="#">+7(111)123456789</a></li>

                                        </ul>

                                        <div class="footer-social">

                                            <span>Find  us on: </span>

                                            <ul class="no-list-style">

                                                <li><a href="#" target="_blank"><i class="fab fa-facebook-f"></i></a></li>

                                                <li><a href="#" target="_blank"><i class="fab fa-twitter"></i></a></li>

                                                <li><a href="#" target="_blank"><i class="fab fa-instagram"></i></a></li>

                                                <li><a href="#" target="_blank"><i class="fab fa-vk"></i></a></li>

                                                <li><a href="#" target="_blank"><i class="fab fa-whatsapp"></i></a></li>

                                            </ul>

                                        </div>

                                    </div>

                                </div>

                            </div>

                            <!-- footer-widget end-->

                            

                        </div>

                    </div>

                    <!-- footer bg-->

                    <div class="footer-bg" data-ran="4"></div>

                    <div class="footer-wave">

                        <svg viewbox="0 0 100 25">

                            <path fill="#fff" d="M0 30 V12 Q30 17 55 12 T100 11 V30z" />

                        </svg>

                    </div>

                    <!-- footer bg  end-->

                </div>

                <!--footer-inner end -->

                <!--sub-footer-->

                <div class="sub-footer  fl-wrap">

                    <div class="container">

                        <div class="copyright"> &#169; Townhub 2019 .  All rights reserved.</div>

                        <div class="lang-wrap">

                            <!--<div class="show-lang"><span><i class="fal fa-globe-europe"></i><strong>En</strong></span><i class="fa fa-caret-down arrlan"></i></div>

                            <ul class="lang-tooltip lang-action no-list-style">

                                <li><a href="#" class="current-lan" data-lantext="En">English</a></li>

                                <li><a href="#" data-lantext="Fr">Français</a></li>

                                <li><a href="#" data-lantext="Es">Español</a></li>

                                <li><a href="#" data-lantext="De">Deutsch</a></li>

                            </ul>-->

                        </div>

                        <div class="subfooter-nav">

                            <ul class="no-list-style">

                                <li><a href="#">Terms of use</a></li>

                                <li><a href="#">Privacy Policy</a></li>

                                <li><a href="#">Blog</a></li>

                            </ul>

                        </div>

                    </div>

                </div>

                <!--sub-footer end -->

            </footer>

            <!--footer end -->  

            <!--map-modal -->

            <div class="map-modal-wrap">

                <div class="map-modal-wrap-overlay"></div>

                <div class="map-modal-item">

                    <div class="map-modal-container fl-wrap">

                        <div class="map-modal fl-wrap">

                            <div id="singleMap" data-latitude="40.7" data-longitude="-73.1"></div>

                        </div>

                        <h3><span>Location for : </span><a href="#">Listing Title</a></h3>

                        <div class="map-modal-close"><i class="fal fa-times"></i></div>

                    </div>

                </div>

            </div>

            <!--map-modal end -->                

            <!--register form -->

            <div class="main-register-wrap modal">

                <div class="reg-overlay"></div>

                <div class="main-register-holder tabs-act">

                    <div class="main-register fl-wrap  modal_main">

                        <div class="main-register_title">Welcome to <span><strong>Town</strong>Hub<strong>.</strong></span></div>

                        <div class="close-reg"><i class="fal fa-times"></i></div>

                        <ul class="tabs-menu fl-wrap no-list-style">

                            <li class="current"><a href="#tab-1"><i class="fal fa-sign-in-alt"></i> Login</a></li>

                            <li><a href="#tab-2"><i class="fal fa-user-plus"></i> Register</a></li>

                        </ul>

                        <!--tabs -->                       

                        <div class="tabs-container">

                            <div class="tab">

                                <!--tab -->

                                <div id="tab-1" class="tab-content first-tab">

                                    <div class="custom-form">

                                        <span style="color: red;" id="loginSpan" ></span>

                                        <form   id="loginForm">

                                            <?php echo csrf_field(); ?>

                                            <label> Adresse e-mail <span>*</span> </label>

                                            

                                            <input name="email" type="text"   onClick="this.select()" value="">

                                            <label > Mot de passe <span>*</span> </label>

                                            <input name="password" type="password"   onClick="this.select()" value="" >

                                            <a type="submit" id="loginSubmit"  class="btn float-btn color2-bg"> Log In <i class="fas fa-caret-right"></i></a>

                                            <div class="clearfix"></div>

                                            <div class="filter-tags">

                                                <input id="check-a3" type="checkbox" name="check">

                                                <label for="check-a3">Remember me</label>

                                            </div>

                                        </form>

                                        <div class="lost_password">

                                            <a href="/auth/forgotPassWord">Lost Your Password?</a>

                                        </div>

                                    </div>

                                </div>

                                <!--tab end -->

                                <!--tab -->

                                <div class="tab">

                                    <div id="tab-2" class="tab-content">

                                        <div class="custom-form">

                                            <span style="color: red;" id="registerSpan" ></span>

                                            <form id="registerForm">

                                                <?php echo csrf_field(); ?>

                                                <label > Nom <span>*</span> </label>

                                                <input name="name" type="text"   onClick="this.select()" value="">



                                                <label > Prénom <span>*</span> </label>

                                                <input name="firstname" type="text"   onClick="this.select()" value="">



                                                <label> Adresse e-mail <span>*</span></label>

                                                <input name="email" type="text"  onClick="this.select()" value="">



                                                <label > Mot de passe <span>*</span></label>

                                                <input name="password" type="password"   onClick="this.select()" value="" >



                                                <div class="filter-tags ft-list">

                                                    <input id="check-a2" type="checkbox" name="check">

                                                    <label for="check-a2">I agree to the <a href="#">Privacy Policy</a></label>

                                                </div>

                                                <div class="clearfix"></div>

                                                <div class="filter-tags ft-list">

                                                    <input id="check-a" type="checkbox" name="check">

                                                    <label for="check-a">I agree to the <a href="#">Terms and Conditions</a></label>

                                                </div>

                                                <div class="clearfix"></div>

                                                <a type="submit"  id="registerSubmit"   class="btn float-btn color2-bg"> Register  <i class="fas fa-caret-right"></i></a>

                                            </form>

                                        </div>

                                    </div>

                                </div>

                                <!--tab end -->

                            </div>

                            <!--tabs end -->

                            <!--<div class="log-separator fl-wrap"><span>or</span></div>

                            <div class="soc-log fl-wrap">

                                <p>For faster login or register use your social account.</p>

                                <a href="#" class="facebook-log"> Facebook</a>

                            </div>-->

                            <div class="wave-bg">

                                <div class='wave -one'></div>

                                <div class='wave -two'></div>

                            </div>

                        </div>

                    </div>

                </div>

            </div>

            <!--register form end -->

            <a class="to-top"><i class="fas fa-caret-up"></i></a>

        </div>



        <?php echo $__env->yieldContent('extrat-div'); ?>



       <!-- <script type="text/javascript" src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>-->



        <?php echo $__env->yieldContent('script'); ?>

        



        <script type="text/javascript">

            var apiAddress = <?php echo json_encode(session()->get('apiAddress')); ?>



    

            // societe autocomplite -----------------------------------------------------------------------------------

    

            let suggestionssociete = [];

           fetch(`${apiAddress}/api/societe/allname`)

            .then(function(response) {

                return response.json();

            })

            .then(function(data) {

                //console.log(data)

                for(i=0; i<data.length; i++){

                    suggestionssociete[i] = data[i]['libelle']

                }

                //console.log(suggestionssociete)

            })

            .catch(function(err) {

                console.log('error: ' + err);

            });

    

            const searchWrapper1 = document.querySelector(".search-input-societe");

            const inputBox1 = searchWrapper1.querySelector("input");

            const suggBox1 = searchWrapper1.querySelector(".autocom-box");

            inputBox1.onkeyup = (e)=>{

                let userData = e.target.value; //user enetered data

                let emptyArray = [];

                if(userData){

                    

                    emptyArray = suggestionssociete.filter((data)=>{

                        //filtering array value and user characters to lowercase and return only those words which are start with user enetered chars

                        return data.toLocaleLowerCase().startsWith(userData.toLocaleLowerCase());

                    });

                    emptyArray = emptyArray.map((data)=>{

                        // passing return data inside li tag

                        return data = `<li>${data}</li>`;

                    });

                    searchWrapper1.classList.add("active"); //show autocomplete box

                    showSuggestions1(emptyArray);

                    let allList = suggBox1.querySelectorAll("li");

                    for (let i = 0; i < allList.length; i++) {

                        //adding onclick attribute in all li tag

                        allList[i].setAttribute("onclick", "select1(this)");

                    }

                }else{

                    searchWrapper1.classList.remove("active"); //hide autocomplete box

                }

            }

            function select1(element){

                let selectData = element.textContent;

                inputBox1.value = selectData;

                searchWrapper1.classList.remove("active");

            }

            function showSuggestions1(list){

                let listData;

                if(!list.length){

                    userValue = inputBox1.value;

                    listData = `<li>${userValue}</li>`;

                }else{

                listData = list.join('');

                }

                suggBox1.innerHTML = listData;

            }

    

            // ville autocomplite ----------------------------------------------------------------------------------

    

    

            let suggestionsville = [];

            fetch(`${apiAddress}/api/ville`)

            .then(function(response) {

                return response.json();

            })

            .then(function(data) {

                //suggestionsville = data

                

                for(i=0; i<data.length; i++){

                    suggestionsville[i] = data[i]['libelle']

                }

                //console.log(suggestionsville)

            })

            .catch(function(err) {

                console.log('error: ' + err);

            });

    

            const searchWrapper2 = document.querySelector(".search-input-ville");

            const inputBox2 = searchWrapper2.querySelector("input");

            const suggBox2 = searchWrapper2.querySelector(".autocom-box");

            inputBox2.onkeyup = (e)=>{

                let userData = e.target.value; //user enetered data

                let emptyArray = [];

                if(userData){

                    

                    emptyArray = suggestionsville.filter((data)=>{

                        //filtering array value and user characters to lowercase and return only those words which are start with user enetered chars

                        return data.toLocaleLowerCase().startsWith(userData.toLocaleLowerCase());

                    });

                    emptyArray = emptyArray.map((data)=>{

                        // passing return data inside li tag

                        return data = `<li>${data}</li>`;

                    });

                    searchWrapper2.classList.add("active"); //show autocomplete box

                    showsuggestionsville2(emptyArray);

                    let allList = suggBox2.querySelectorAll("li");

                    for (let i = 0; i < allList.length; i++) {

                        //adding onclick attribute in all li tag

                        allList[i].setAttribute("onclick", "select2(this)");

                    }

                }else{

                    searchWrapper2.classList.remove("active"); //hide autocomplete box

                }

            }

            function select2(element){

                let selectData = element.textContent;

                inputBox2.value = selectData;

                searchWrapper2.classList.remove("active");

            }

            function showsuggestionsville2(list){

                let listData;

                if(!list.length){

                    userValue = inputBox2.value;

                    listData = `<li>${userValue}</li>`;

                }else{

                listData = list.join('');

                }

                suggBox2.innerHTML = listData;

            }

    

            /**** *************** SECTEUR *************************************  **/

    

            fetch(`${apiAddress}/api/secteur`)

            .then(function(response) {

                return response.json();

            })

            .then(function(data) {

                var mainContainer = document.getElementById("secteur");

                var div = document.createElement("option");

                //console.log(data);

                mainContainer.innerHTML = '';

                mainContainer.innerHTML += "<option value='' selected> Categories </option>";

                for (var i = 0; i < data.length; i++) {

                    mainContainer.innerHTML += '<option value="' + data[i].id + '" data-icon=" " data-tokens="'+ data[i].libelle +'">' + data[i].libelle + '</option>';

                    // div.innerHTML = '<option value="' + data[i].id + '">' + data[i].libelle + '</option>';

                    // mainContainer.appendChild(div); <option data-icon="glyphicon-heart" data-tokens="ketchup mustard">Hot Dog, Fries and a Soda</option>

                }

               

            })

            .catch(function(err) {

                console.log('error: ' + err);

            });

    

    

        </script>



        <script type="text/javascript">

        

            document.getElementById('loginSubmit').addEventListener("click", function(){

                var forms = document.getElementById('loginForm');

                var data = new FormData(forms)

                const value = Object.fromEntries(data.entries());

                //console.log(value['email'] + ' - ' + value['password']);

                fetch(`${apiAddress}/api/auth/login`, {

                    method: 'POST',

                    headers: {

                        Accept: 'application/json',

                        'Content-Type': 'application/json'

                    },

                    body: JSON.stringify({

                        email: value['email'],

                        password: value['password'],

                    })

                }).then(function(response) {

                    return response.json();

                })

                .then(function(data) {

                    //console.log(data)

                    //imgdivfunction(data);

                    



                   if(data == "Password wrong"){

                       var span = document.getElementById('loginSpan')

                       span.innerHTML = data

                   }else if(data == "Email not found"){

                       var span = document.getElementById('loginSpan')

                       span.innerHTML = data

                   }else{

                       //console.log(data)

                       //var url = '/auth/login/' + data;

                        //document.location.href = url;



                        $.ajaxSetup({

                            headers: {

                                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')

                            }   

                        });



                        $.ajax({

                            type: 'post',

                            url: '/auth/login',

                            data: {

                                user: data,

                            },

                        })

                        .done(function(data){

                            // show the response

                            console.log(data);

                            if(data == "true"){

                                //location.reload();

                                document.location.href='/dashboard';

                            }

                            

                        })

                        .fail(function() {

                            // just in case posting your form failed

                            alert( "Posting failed." );

                        });

                          

                   }



                })

                .catch((error) => ("Something went wrong!", error));

            });



            document.getElementById('registerSubmit').addEventListener("click", function(){

                var forms = document.getElementById('registerForm');

                var data = new FormData(forms)

                const value = Object.fromEntries(data.entries());

                //console.log(value['email'] + ' - ' + value['password'] + ' - ' + value['name'] + ' - ' + value['firstname']);

                fetch(`${apiAddress}/api/auth/register`, {

                    method: 'POST',

                    headers: {

                        Accept: 'application/json',

                        'Content-Type': 'application/json'

                    },

                    body: JSON.stringify({

                        email: value['email'],

                        password: value['password'],

                        nom: value['name'],

                        prenom: value['firstname'],

                    })

                }).then(function(response) {

                    return response.json();

                })

                .then(function(data) {

                    //console.log('-'+data+'-')

                    //imgdivfunction(data);

                    



                   if(data == "Cet email existe dejà"){

                       var span = document.getElementById('registerSpan')

                       span.innerHTML = data

                   }else if(data['Statut']){

                       //console.log(data)

                       location.reload();   

                   }



                })

                .catch((error) => ("Something went wrong!", error));

            });

        

        </script>

                              

    </body>

</html><?php /**PATH D:\DevWeb\AFB\AFB2\resources\views/layouts/main.blade.php ENDPATH**/ ?>