<?php

use Illuminate\Support\Facades\Route;
use Illuminate\Support\Facades\Http;
use Illuminate\Http\Request;
use App\Http\Controllers\AuthController;
use App\Http\Controllers\UserController;
use App\Http\Controllers\SocieteController;
use App\Http\Controllers\PofessionnelController;

/*
|--------------------------------------------------------------------------
| Web Routes
|-------------------------------------------------------------------------
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
*/

Route::get('/', function (Request $request) {
    if(!$request->session()->has('user')){
        $request->session()->put('user', null);
    }

    if(!$request->session()->has('pays')){
        $request->session()->put('pays', '');
        $request->session()->put('paysCode', '');
        $request->session()->put('paysUrl', 'afrique.png');
    }

    $apiAddress = 'http://192.168.1.72:3000';
   // $apiAddress = '//beta.afrobase.net';

    $request->session()->put('apiAddress', $apiAddress);

    $response1 = Http::post($apiAddress.'/api/annonce/recherche', [
        'word' => '',
        'pays' => 3,
    ]);
    //dd($response1->json());
    return view('home')->with('apiAddress', $apiAddress)->with('pays', $request->session()->get('pays'))->with('paysCode', $request->session()->get('paysCode'))->with('annonce', $response1->json());
});

Route::get('/setchosepays/{pays}/{code}/{url}',function(Request $request){
    //dd($request->code);
    if($request->code == " "){
        $request->session()->put('pays', '');
        $request->session()->put('paysCode', '');
        $request->session()->put('paysUrl', $request->url);
    }else{
        $request->session()->put('pays', $request->pays);
        $request->session()->put('paysCode', $request->code);
        $request->session()->put('paysUrl', $request->url);
    }
    
    return redirect('/');
});

//--------------------------------------------- auth ----------------------------------------------------

Route::post('/auth/register', [AuthController::class, 'register']);

Route::post('/auth/login', [AuthController::class, 'login']);

Route::get('/auth/logout', [AuthController::class, 'logout']);

//--------------------------------------------- end auth --------------------------------------------------

//-------------------------------------- user dashboard ----------------------------------------------------

Route::get('/dashboard', [UserController::class, 'dashboard']);

Route::get('/dashboard-myprofile/{id}', [UserController::class, 'myprofile']);

Route::get('/dashboard-password', [UserController::class, 'password']);

Route::get('/dashboard-add-listing', [UserController::class, 'listingSociete']);

Route::get('/dashboard-add-listing2/{id}',[UserController::class, 'addListing']);

Route::get('/dashboard/professionel/listing', [UserController::class, 'listingProfessionel']);

Route::post('/update/profile', [UserController::class, 'updateProfile']);

Route::post('/create/profile', [UserController::class, 'createPrfessionnel']);

Route::get('/create/annonce',[UserController::class, 'createAnnonce']);

Route::get('/created/annonce', [UserController::class, 'createdAnnonces']);

Route::get('/dashboard/annonce/listing', [UserController::class, 'listingAnnonce']);

Route::get('/dashboard/annonce/singleListing/{id}', [UserController::class, 'singleListingAnnonce']);

Route::get('/allannonce', [UserController::class, 'allAnnonce']);

//------------------------------------ end user dashboard --------------------------------------------------


//-------------------------------------- societe --------------------------------------------------------
Route::get('/create-societe', [SocieteController::class, 'createSociete']);

Route::post('/societe/update', [SocieteController::class, 'updateSociete']);

Route::get('/societe-listing/{id}/{nom}', [SocieteController::class, 'societeListing']);

Route::post('/listing-Societe', [SocieteController::class, 'listingSociete']);

Route::get('/all/societe',[SocieteController::class, 'allSociete']);

Route::get('/listing-Societe/suivant', [SocieteController::class, 'listingSocieteSuivant']);

Route::get('/listing-Societe/precedent', [SocieteController::class, 'listingSocietePrecedent']);

Route::post('/message_societe', [SocieteController::class, 'messageSociete']);

// ---------------------------------------- end societe ------------------------------------------------


//----------------------------------------Pofessionnel -------------------------------------------------

Route::get('/listing-Professionel', [PofessionnelController::class, 'listingProfessionel']);

Route::get('/professionel/single/{id}', [PofessionnelController::class, 'singleListingProfessionnel']);

Route::get('/professionel/create', [PofessionnelController::class, 'createProfession']);

// ---------------------------------------- end Pofessionnel ------------------------------------------------



//---------------------------------------- Annonces ----------------------------------------------------------

