<?php

namespace App\Http\Controllers;

use Illuminate\Support\Facades\Http;
use Illuminate\Http\Request;

class SocieteController extends Controller{

    public function createSociete(Request $request){
        $apiAddress = $request->session()->get('apiAddress');
        return view('societeForm')->with('apiAddress',$apiAddress);
    }

    //*************************************************************************************************** */

    public function societeListing(Request $request){
        $apiAddress = $request->session()->get('apiAddress');
        $user_id;
        if($request->session()->has('user')){
            $user = $request->session()->get('user');
            $user_id = $user['id'];
        }else{
            $user_id = 0;
        }

        $response = Http::post($apiAddress.'/api/societe', [
            'id' => $request->id,
        ]);
        $donnee = $response->json()[0];
        //dd($donnee);
        return view('singleListingSociete')->with('donnee', $donnee)->with('apiAddress',$apiAddress)->with('user_id',$user_id);
    }

    /********************************************************************************************************** */

    public function listingSociete(Request $request){
        //dd($request->word);


        try {
            $apiAddress = $request->session()->get('apiAddress');
            $word;
            $ville;
            $pays = $request->session()->get('pays');
            if(!$request->word){
                $word = '';
            }else{
                $word = $request->word;
            }

            if(!$request->ville){
                $ville = '';
            }else{
                $ville = $request->ville;
            }

            if(!$pays){
                $pays = '';
            }

            //dd($pays);

            if(!$request->secteur){
                $secteur = '';
            }else{
                $secteur = $request->secteur;
            }


            $response = Http::post($apiAddress.'/api/societe/search', [
                'word' => $word,
                'ville' => $ville,
                'secteur' => $secteur,
                'pays' => $request->session()->get('pays'),
            ]);
            //dd($response->json());

            $donnee = $response->json();
            //dd($donnee);

            return view('listingSociete')->with('donnee', $donnee)->with('apiAddress',$apiAddress);
        } catch (\Throwable $e) {
            dd($e);
        }
    }

    /***************************************************************************************************************************************** */

    

    /****************************************************************************************************************************************** */

    public function updateSociete(Request $request){
        


    }
}