<?php

use Illuminate\Support\Facades\Route;
use Illuminate\Support\Facades\Http;
use Illuminate\Http\Request;
use App\Http\Controllers\AuthController;
use App\Http\Controllers\UserController;
use App\Http\Controllers\SocieteController;
use App\Http\Controllers\PofessionnelController;
use App\Http\Controllers\ServicesController;
use App\Http\Controllers\FoireAfriqueController;

/*
|--------------------------------------------------------------------------
| Web Routes
|-------------------------------------------------------------------------
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
*/

Route::get('/', function (Request $request) {
    if(!$request->session()->has('user')){
        $request->session()->put('user', null);
    }

    if(!$request->session()->has('pays')){
        $request->session()->put('pays', '');
        $request->session()->put('paysCode', '');
        $request->session()->put('paysUrl', 'afrique.png');
    }

   // $apiAddress = 'http://192.168.1.73:3000';
    $apiAddress = '//beta.afrobase.net';

    $request->session()->put('apiAddress', $apiAddress);

    $response1 = Http::post($apiAddress.'/api/annonce/recherche', [
        'word' => '',
        'secteur' => '',
        'pays' => 3,
    ]);
    //dd($response1->json());
    return view('home')->with('apiAddress', $apiAddress)->with('pays', $request->session()->get('pays'))->with('paysCode', $request->session()->get('paysCode'))->with('annonce', $response1->json());
});

Route::get('/setchosepays/{pays}/{code}/{url}',function(Request $request){
    //dd($request->code);
    if($request->code == " "){
        $request->session()->put('pays', '');
        $request->session()->put('paysCode', '');
        $request->session()->put('paysUrl', $request->url);
    }else{
        $request->session()->put('pays', $request->pays);
        $request->session()->put('paysCode', $request->code);
        $request->session()->put('paysUrl', $request->url);
    }
    
    return redirect('/');
});

//--------------------------------------------- auth ----------------------------------------------------

Route::post('/auth/register', [AuthController::class, 'register']);

Route::post('/auth/login', [AuthController::class, 'login']);

Route::get('/auth/logout', [AuthController::class, 'logout']);

Route::get('/auth/forgotPassWord', [AuthController::class, 'forgotPassWord']);

Route::get('/auth/forgotPassWord/email', [AuthController::class, 'forgotPassWordEmail']);

Route::get('/auth/passwordReset/{token}', [AuthController::class, 'PassWordReset']);

//--------------------------------------------- end auth --------------------------------------------------

//-------------------------------------- user dashboard ----------------------------------------------------

Route::get('/dashboard', [UserController::class, 'dashboard']);

Route::get('/dashboard-myprofile/{id}', [UserController::class, 'myprofile']);

Route::get('/dashboard-password', [UserController::class, 'password']);

Route::get('/dashboard-add-listing', [UserController::class, 'listingSociete']);

Route::get('/dashboard-add-listing2/{id}',[UserController::class, 'addListing']);

Route::get('/dashboard/professionel/listing', [UserController::class, 'listingProfessionel']);

Route::post('/update/profile', [UserController::class, 'updateProfile']);

Route::post('/create/profile', [UserController::class, 'createPrfessionnel']);

//------------------------------------ ANNONCES ---------------------------------------------------------------

Route::get('/create/annonce',[UserController::class, 'createAnnonce']);

Route::get('/created/annonce', [UserController::class, 'createdAnnonces']);

Route::get('/dashboard/annonce/listing', [UserController::class, 'listingAnnonce']);

Route::get('/dashboard/annonce/singleListing/{id}', [UserController::class, 'singleListingAnnonce']);

Route::get('/allannonce', [UserController::class, 'allAnnonce']);

Route::get('/annonce/listing', [UserController::class, 'Annonce']);

Route::post('/annonce/search', [UserController::class, 'searchAnnonce']);

//------------------------------------ end user dashboard --------------------------------------------------


//-------------------------------------- societe --------------------------------------------------------
Route::get('/create-societe', [SocieteController::class, 'createSociete']);

Route::post('/societe/update', [SocieteController::class, 'updateSociete']);

Route::get('/societe-listing/{id}/{nom}', [SocieteController::class, 'societeListing']);

Route::post('/listing-Societe', [SocieteController::class, 'listingSociete']);

Route::get('/all/societe',[SocieteController::class, 'allSociete']);

Route::get('/listing-Societe/suivant', [SocieteController::class, 'listingSocieteSuivant']);

Route::get('/listing-Societe/precedent', [SocieteController::class, 'listingSocietePrecedent']);

Route::post('/message_societe', [SocieteController::class, 'messageSociete']);

// ---------------------------------------- end societe ------------------------------------------------


//----------------------------------------Pofessionnel -------------------------------------------------

Route::post('/listing-Professionel', [PofessionnelController::class, 'listingProfessionel']);

Route::get('/professionel/single/{id}', [PofessionnelController::class, 'singleListingProfessionnel']);

Route::get('/professionel/create', [PofessionnelController::class, 'createProfession']);

Route::get('/professionel/getall', [PofessionnelController::class, 'getAllProfession']);

Route::get('/professionel/suiv', [PofessionnelController::class, 'getProfessionSuiv']);

Route::get('/professionel/prev', [PofessionnelController::class, 'getProfessionPrev']);

// ---------------------------------------- end Pofessionnel ------------------------------------------------



//---------------------------------------- Annonces ------------------------------------------------------------



//---------------------------------------end Annonces ----------------------------------------------------------

//-------------------------------------- Services --------------------------------------------------------------------

Route::get('/services', [ServicesController::class, 'index']);

//---------------------------------------- end Services -------------------------------------------------------------

//--------------------------------------- foire afrique --------------------------------------------------------------

Route::get('/foire_d_afrique',[FoireAfriqueController::class, 'index']);

Route::get('/foire_d_afrique/next',[FoireAfriqueController::class, 'suivant']);

Route::get('/foire_d_afrique/prev',[FoireAfriqueController::class, 'precedent']);

Route::get('/foire_d_afrique/search',[FoireAfriqueController::class, 'search']);

Route::get('/foire_d_afrique/single',[FoireAfriqueController::class, 'single']);

