<?php

namespace App\Http\Controllers;

use App\Mail\MailMessage;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\Mail;


class SocieteController extends Controller{

    public function createSociete(Request $request){
        $apiAddress = $request->session()->get('apiAddress');
        return view('societe.societeForm')->with('apiAddress',$apiAddress);
    }

    /*************************************************************************************************** */

    public function societeListing(Request $request){
        $apiAddress = $request->session()->get('apiAddress');
        $user_id = 0;
        if($request->session()->has('user')){
            $user = $request->session()->get('user');
            $user_id = $user['id'];
        }else{
            $user_id = 0;
        }

        $response = Http::post($apiAddress.'/api/societe', [
            'id' => $request->id,
        ]);
        $donnee = $response->json()[0];


        //dd($donnee);

        $response2 = Http::get($apiAddress.'/api/secteur');
        $secteur = $response2->json();

        $response3 = Http::get($apiAddress.'/api/ville');
        $ville = $response3->json();


        return view('societe.singleListingSociete')->with('donnee', $donnee)->with('apiAddress',$apiAddress)->with('user_id',$user_id)->with('secteurs',$secteur)->with('ville',$ville);
    }

    /********************************************************************************************************** */

    public function listingSociete(Request $request){
        //dd($request->word);


        try {
            $apiAddress = $request->session()->get('apiAddress');
            $word = '';
            $ville = '';
            $pays = $request->session()->get('pays');
            if(!$request->word){
                $word = '';
            }else{
                $word = $request->word;
            }

            if(!$request->ville){
                $ville = '';
            }else{
                $ville = $request->ville;
            }

            if(!$pays){
                $pays = '';
            }

            //dd($pays);

            if(!$request->secteur){
                $secteur = '';
            }else{
                $secteur = $request->secteur;
            }

            $recherche = ['word'=> $word, 'ville'=> $ville, 'secteur'=> $secteur];

            $request->session()->put('recherche',$recherche);
            $request->session()->put('page', 0);

            $response = Http::post($apiAddress.'/api/societe/search?page=0&size=15', [
                'word' => $word,
                'ville' => $ville,
                'secteur' => $secteur,
                'pays' => $request->session()->get('pays'),
            ]);
           // dd($response->json());

            

            $donnee = $response->json();
            $response2 = Http::get($apiAddress.'/api/secteur');
            $secteur = $response2->json();

            $response3 = Http::get($apiAddress.'/api/ville');
            $ville = $response3->json();
            //dd($donnee);

            return view('societe.listingSociete')->with('donnee', $donnee['data'])->with('apiAddress',$apiAddress)->with('secteurs',$secteur)->with('count',$donnee['count'])->with('ville',$ville);
        } catch (\Throwable $e) {
            dd($e);
        }
    }

    /***************************************************************************************************************************************** */

    public function allSociete(Request $request){
        $apiAddress = $request->session()->get('apiAddress');
        $pays = $request->session()->get('pays');

        //dd($request);

        $ville = '';
        $word = '';
        $secteur = '';

        $recherche = ['word'=> $word, 'ville'=> $ville, 'secteur'=> $secteur];

        $request->session()->put('recherche',$recherche);
        $request->session()->put('page', 0);

        $response = Http::post($apiAddress.'/api/societe/search?page=0&size=15', [
            'word' => '',
            'ville' => '',
            'secteur' => '',
            'pays' => $pays,
        ]);
        $donnee = $response->json();

        $response2 = Http::get($apiAddress.'/api/secteur');
        $secteur = $response2->json();


        $response3 = Http::get($apiAddress.'/api/ville');
        $ville = $response3->json();

        //dd($donnee);

        return view('societe.listingallsociete')->with('donnee', $donnee['data'])->with('apiAddress',$apiAddress)->with('secteurs',$secteur)->with('count',$donnee['count'])->with('ville',$ville);
    }

    /****************************************************************************************************************************************** */

    public function updateSociete(Request $request){}

    /**************************************************************************************************************************************** */

    public function listingSocieteSuivant(Request $request){

        $apiAddress = $request->session()->get('apiAddress');
        $response2 = Http::get($apiAddress.'/api/secteur');
        $secteur = $response2->json();

        $recherche = $request->session()->get('recherche');
        $page = $request->session()->get('page');
        $page = $page + 1;

        //dd($recherche);

        $pays = $request->session()->get('pays');
        $response = Http::post($apiAddress.'/api/societe/search?page='.$page.'&size=15', [
            'word' => $recherche['word'],
            'ville' => $recherche['ville'],
            'secteur' => $recherche['secteur'],
            'pays' => $pays,
        ]);
        $donnee = $response->json();
        $request->session()->put('page', $page);

        $response3 = Http::get($apiAddress.'/api/ville');
        $ville = $response3->json();

        return view('societe.listingSocieteSuivant')->with('donnee', $donnee['data'])->with('apiAddress',$apiAddress)->with('secteurs',$secteur)->with('count',$donnee['count'])->with('ville',$ville);

    }

    /****************************************************************************************************************************************** */

    public function listingSocietePrecedent(Request $request){

        $apiAddress = $request->session()->get('apiAddress');
        $response2 = Http::get($apiAddress.'/api/secteur');
        $secteur = $response2->json();

        $recherche = $request->session()->get('recherche');
        $page = $request->session()->get('page');
        $page = $page - 1;

        $pays = $request->session()->get('pays');
        $response = Http::post($apiAddress.'/api/societe/search?page='.$page.'&size=15', [
            'word' => $recherche['word'],
            'ville' => $recherche['ville'],
            'secteur' => $recherche['secteur'],
            'pays' => $pays,
        ]);
        $donnee = $response->json();
        $request->session()->put('page', $page);

        $response3 = Http::get($apiAddress.'/api/ville');
        $ville = $response3->json();

        return view('societe.listingSocietePrecedent')->with('donnee', $donnee['data'])->with('apiAddress',$apiAddress)->with('secteurs',$secteur)->with('count',$donnee['count'])->with('ville',$ville);

    }

    /*************************************************************************************************************************** */

    public function messageSociete(Request $request){
        //dd($request);

        $data = [
            'S_email' => $request->societe_email,
            'sujet' => $request->subject,
            'C_email' => $request->customer_email,
            'name' => $request->name,
            'comments' => $request->comments,
            'tel' => $request->tel
        ];

        Mail::to($data['S_email'])->send(new MailMessage($data));

        return redirect()->back();
    }


}