<?php
namespace App\Http\Controllers;

use Illuminate\Support\Facades\Http;
use Illuminate\Http\Request;

class FoireAfriqueController extends Controller{

  public function index(Request $request){


    $apiAddress = $request->session()->get('apiAddress');
    $pays = $request->session()->get('pays');

    //dd($request);

    $ville = '';
    $word = '';
    $secteur = '';

    $recherche = ['word'=> $word, 'ville'=> $ville, 'secteur'=> $secteur];

    $request->session()->put('recherche',$recherche);
    $request->session()->put('page', 0);

    $response = Http::post($apiAddress.'/api/societe/search?page=0&size=15', [
        'word' => '',
        'ville' => '',
        'secteur' => '',
        'pays' => $pays,
    ]);
    $donnee = $response->json();

    $response2 = Http::get($apiAddress.'/api/secteur');
    $secteur = $response2->json();


    $response3 = Http::get($apiAddress.'/api/ville');
    $ville = $response3->json();

    return view('Foire d_Afrique_PARIS.index')->with('donnee', $donnee['data'])->with('apiAddress',$apiAddress)->with('secteurs',$secteur)->with('count',$donnee['count'])->with('ville',$ville);
  }

  public function suivant(Request $request){

    $apiAddress = $request->session()->get('apiAddress');
    $response2 = Http::get($apiAddress.'/api/secteur');
    $secteur = $response2->json();

    $recherche = $request->session()->get('recherche');
    $page = $request->session()->get('page');
    $page = $page + 1;

    //dd($recherche);

    $pays = $request->session()->get('pays');
    $response = Http::post($apiAddress.'/api/societe/search?page='.$page.'&size=15', [
        'word' => $recherche['word'],
        'ville' => $recherche['ville'],
        'secteur' => $recherche['secteur'],
        'pays' => $pays,
    ]);
    $donnee = $response->json();
    $request->session()->put('page', $page);

    $response3 = Http::get($apiAddress.'/api/ville');
    $ville = $response3->json();

    return view('Foire d_Afrique_PARIS.suv')->with('donnee', $donnee['data'])->with('apiAddress',$apiAddress)->with('secteurs',$secteur)->with('count',$donnee['count'])->with('ville',$ville);

  }

  public function precedent(Request $request){

    $apiAddress = $request->session()->get('apiAddress');
    $response2 = Http::get($apiAddress.'/api/secteur');
    $secteur = $response2->json();

    $recherche = $request->session()->get('recherche');
    $page = $request->session()->get('page');
    $page = $page - 1;

    $pays = $request->session()->get('pays');
    $response = Http::post($apiAddress.'/api/societe/search?page='.$page.'&size=15', [
        'word' => $recherche['word'],
        'ville' => $recherche['ville'],
        'secteur' => $recherche['secteur'],
        'pays' => $pays,
    ]);
    $donnee = $response->json();
    $request->session()->put('page', $page);

    $response3 = Http::get($apiAddress.'/api/ville');
    $ville = $response3->json();

    return view('Foire Foire d_Afrique_PARIS.prev')->with('donnee', $donnee['data'])->with('apiAddress',$apiAddress)->with('secteurs',$secteur)->with('count',$donnee['count'])->with('ville',$ville);
    
  }


}