@extends('layouts.main')
 

@section('extra-css')
    
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.0.2/dist/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-EVSTQN3/azprG1Anm3QDgpJLIm9Nao0Yz1ztcQTwFspd3yD65VohhpuuCOmLASjC" crossorigin="anonymous">

<style>
  :root {
    --primary-color: rgb(11, 78, 179)
}

*,
*::before,
*::after {
    box-sizing: border-box
}

body {
    font-family: Montserrat, "Segoe UI", Tahoma, Geneva, Verdana, sans-serif;
    margin: 0;
    display: grid;
    place-items: center;
    min-height: 100vh;
    background-color: #0b4eb3
}

label {
    display: block;
    margin-bottom: 0.5rem
}

input {
    display: block;
    width: 100%;
    padding: 0.75rem;
    border: 1px solid #ccc;
    border-radius: 0.25rem;
    height: 50px
}

.width-50 {
    width: 50%
}

.ml-auto {
    margin-left: auto
}

.text-center {
    text-align: center
}

.progressbar {
    position: relative;
    display: flex;
    justify-content: space-between;
    counter-reset: step;
    margin: 2rem 0 4rem
}

.progressbar::before,
.progress {
    content: "";
    position: absolute;
    top: 50%;
    transform: translateY(-50%);
    height: 4px;
    width: 100%;
    background-color: #dcdcdc;
    z-index: 1
}

.progress {
    background-color: rgb(0 128 0);
    width: 0%;
    transition: 0.3s
}

.progress-step {
    width: 2.1875rem;
    height: 2.1875rem;
    background-color: #dcdcdc;
    border-radius: 50%;
    display: flex;
    justify-content: center;
    align-items: center;
    z-index: 1
}

.progress-step::before {
    counter-increment: step;
    content: counter(step)
}

.progress-step::after {
    content: attr(data-title);
    position: absolute;
    top: calc(100% + 0.5rem);
    font-size: 0.85rem;
    color: #666
}

.progress-step-active {
    background-color: var(--primary-color);
    color: #f3f3f3
}

.form {
    width: clamp(520px, 30%, 430px);
    margin: 0 auto;
    border: none;
    border-radius: 10px !important;
    overflow: hidden;
    padding: 1.5rem;
    background-color: #fff;
    padding: 20px 30px
}

@media only screen and (max-width: 768px){
  .form{
    width: clamp(320px, 30%, 430px);
  }
}

.step-forms {
    display: none;
    transform-origin: top;
    animation: animate 1s
}

.step-forms-active {
    display: block
}

.group-inputs {
    margin: 1rem 0
}

@keyframes animate {
    from {
        transform: scale(1, 0);
        opacity: 0
    }

    to {
        transform: scale(1, 1);
        opacity: 1
    }
}

.btns-group {
    display: grid;
    grid-template-columns: repeat(2, 1fr);
    gap: 1.5rem
}

.btn {
    padding: 0.75rem;
    display: block;
    text-decoration: none;
    background-color: var(--primary-color);
    color: #f3f3f3;
    text-align: center;
    border-radius: 0.25rem;
    cursor: pointer;
    transition: 0.3s
}

.btn:hover {
    box-shadow: 0 0 0 2px #fff, 0 0 0 3px var(--primary-color)
}

.progress-step-check {
    position: relative;
    background-color: green !important;
    transition: all 0.8s
}

.progress-step-check::before {
    position: absolute;
    content: '\2713';
    /*width: 100%;*/
    height: 100%;
    top: 8px;
    left: 13px;
    font-size: 12px
}

.group-inputs {
    position: relative
}

.group-inputs label {
    font-size: 13px;
    position: absolute;
    height: 19px;
    padding: 4px 7px;
    top: -14px;
    left: 10px;
    color: #a2a2a2;
    background-color: white
}

.welcome {
    height: 450px;
    /*width: 350px;*/
    background-color: #fff;
    border-radius: 6px;
    display: flex;
    justify-content: center;
    align-items: center
}

.welcome .content {
    display: flex;
    align-items: center;
    flex-direction: column
}

.checkmark__circle {
    stroke-dasharray: 166;
    stroke-dashoffset: 166;
    stroke-width: 2;
    stroke-miterlimit: 10;
    stroke: #7ac142;
    fill: none;
    animation: stroke 0.6s cubic-bezier(0.65, 0, 0.45, 1) forwards
}

.checkmark {
    width: 56px;
    height: 56px;
    border-radius: 50%;
    display: block;
    stroke-width: 2;
    stroke: #fff;
    stroke-miterlimit: 10;
    margin: 10% auto;
    box-shadow: inset 0px 0px 0px #7ac142;
    animation: fill .4s ease-in-out .4s forwards, scale .3s ease-in-out .9s both
}

.checkmark__check {
    transform-origin: 50% 50%;
    stroke-dasharray: 48;
    stroke-dashoffset: 48;
    animation: stroke 0.3s cubic-bezier(0.65, 0, 0.45, 1) 0.8s forwards
}

@keyframes stroke {
    100% {
        stroke-dashoffset: 0
    }
}

@keyframes scale {

    0%,
    100% {
        transform: none
    }

    50% {
        transform: scale3d(1.1, 1.1, 1)
    }
}

@keyframes fill {
    100% {
        box-shadow: inset 0px 0px 0px 30px #7ac142
    }
}
</style>

@endsection

@section('content')

<section style="background: #ddd">
  <form action="#" class="form" id="forms" onsubmit="event.preventDefault()" style="margin-top: 100px;">
    <input type="text" name="users_id" hidden value="{{ session()->get('user')['id'] }}">
    <div class="progressbar">
        <div class="progress" id="progress"></div>
        <div class="progress-step progress-step-active" data-title=""></div>
        <div class="progress-step" data-title=""></div>
        <div class="progress-step" data-title=""></div>
    </div>

    <div class="step-forms step-forms-active">
        <div class="group-inputs"> <label for="nom">Nom de la societe</label> <input type="text" name="libelle" id="nom" id="step1" value="" /> </div>
        <div class="group-inputs"> <label for="email">Email</label> <input type="text" name="email" id="email" id="step1" value="" /> </div>
        <div class="group-inputs"> <label for="continent">Secteur d'activité</label> 
            <select class="form-select" aria-label="Default select example" name="secteur" id="secteurActivites" >
                
              </select>
        </div>
       <div class="group-inputs form-floating"> 
            <div class="form-floating">
                <textarea class="form-control" name="description"  id="floatingTextarea"></textarea>
                <label for="floatingTextarea">Description</label>
            </div>
        </div>
        <div class=""> <a href="#" class="btn btn-next width-50 ml-auto" id="btn1" style="margin-top:10px;">Next</a> </div>
        
    </div>

    <div class="step-forms">

        <div class="group-inputs"> <label for="pays">Pays</label> 
            <select class="form-select" aria-label="Default select example" name="pays" id="pays" >
                
              </select>
        </div>

        <div class="group-inputs"> <label for="region">Région</label> 
            <select class="form-select" aria-label="Default select example" name="region" id="region" >
                
              </select>
        </div>

        <div class="group-inputs"> <label for="ville">Ville</label> 
            <select class="form-select" aria-label="Default select example" name="ville" id="ville" >
                
              </select>
        </div>

        <div class="group-inputs"> <label for="adresse">Address</label> <input type="text" name="adresse" id="address"  /> </div>
        <div class="btns-group"> <a href="#" class="btn btn-prev">Previous</a> <a href="#" class="btn btn-next" id="btn2" >Next</a> </div>
    </div>
    
    <div class="step-forms">
        
        <div class="group-inputs"> <label for="numero1">Numéro </label> <input type="text" name="tel1" id="numero1" placeholder="Numéro 1 / Numéro 2 / Numéro 3"  /> </div>

        <div class="group-inputs"> <label for="whatsapp">Whatsapp </label> <input type="text" name="whatsapp" id="whatsapp" placeholder=""  /> </div>

        <div class="group-inputs"> <label for="dirigeant">Dirigeant</label> <input type="text" name="dirigeant" id="dirigeant"  /> </div>
        <div class="group-inputs"> <label for="bp">Boite Postale</label> <input type="text" name="bp" id="bp"  /> </div>
        <div class="group-inputs"> <label for="rccm">RCCM</label> <input type="text" name="rccm" id="rccm"  /> </div>
        <div class="group-inputs"> <label for="nif">NIF</label> <input type="text" name="nif" id="nif"  /> </div>
        <div class="btns-group"> <a href="#" class="btn btn-prev">Previous</a> <input type="submit" value="Submit" id="submit-form"  class="btn" /> </div>
    </div>

  </form>
</section>

@endsection

@section('script')

    <script src="{{ asset('js/jquery.min.js') }}"></script>
    <script src="{{ asset('js/plugins.js') }}"></script>
    <script src="{{ asset('js/scripts.js') }}"></script>
    
    <script>
        const prevBtns = document.querySelectorAll(".btn-prev");
        const nextBtns = document.querySelectorAll(".btn-next");
        const progress = document.getElementById("progress");
        const formSteps = document.querySelectorAll(".step-forms");
        const progressSteps = document.querySelectorAll(".progress-step");

        var apiAddress = {!! json_encode($apiAddress) !!}

        //document.querySelector('#btn1').disabled = true;

        let formStepsNum = 0;

        document.getElementById('btn1').addEventListener('click', function(){

            var nomValue = document.getElementById("nom").value;
            var emailValue = document.getElementById("email").value;
            //console.log(nomValue +' - ' + emailValue);
            if(nomValue.length > 1 && emailValue.length > 1){
                //console.log('OK OK')
                formStepsNum++;
                updateFormSteps();
                updateProgressbar();

            }else{
                if(nomValue.length < 1){
                    document.getElementById('nom').style.borderColor = 'red'
                }else{
                    document.getElementById('nom').style.borderColor = '#ccc'
                }

                if(emailValue.length < 1){
                    document.getElementById('email').style.borderColor = 'red'
                }else{
                    document.getElementById('email').style.borderColor = '#ccc'
                }
                
                //console.log('NO NO')
            }

        })
        
        document.getElementById('btn2').addEventListener('click', function(){

            var nomValue = document.getElementById("nom").value;
            var emailValue = document.getElementById("email").value;
            //console.log(nomValue +' - ' + emailValue);
            if(nomValue.length > 1 && emailValue.length > 1){
                //console.log('OK OK')
                formStepsNum++;
                updateFormSteps();
                updateProgressbar();

            }else{
                if(nomValue.length < 1){
                    document.getElementById('nom').style.borderColor = 'red'
                }else{
                    document.getElementById('nom').style.borderColor = '#ccc'
                }

                if(emailValue.length < 1){
                    document.getElementById('email').style.borderColor = 'red'
                }else{
                    document.getElementById('email').style.borderColor = '#ccc'
                }
                
                //console.log('NO NO')
            }

        })
        /*
        document.getElementById('btn3').addEventListener('click', function(){

            var nomValue = document.getElementById("nom").value;
            var emailValue = document.getElementById("email").value;
            //console.log(nomValue +' - ' + emailValue);
            if(nomValue.length > 1 && emailValue.length > 1){
                //console.log('OK OK')
                formStepsNum++;
                updateFormSteps();
                updateProgressbar();

            }else{
                if(nomValue.length < 1){
                    document.getElementById('nom').style.borderColor = 'red'
                }else{
                    document.getElementById('nom').style.borderColor = '#ccc'
                }

                if(emailValue.length < 1){
                    document.getElementById('email').style.borderColor = 'red'
                }else{
                    document.getElementById('email').style.borderColor = '#ccc'
                }
                
                //console.log('NO NO')
            }

        })
        */
        nextBtns.forEach((btn) => {

            

            
        });

        prevBtns.forEach((btn) => {
            btn.addEventListener("click", () => {
                formStepsNum--;
                updateFormSteps();
                updateProgressbar();
            });
        });

        function updateFormSteps() {
            formSteps.forEach((formStep) => {
                formStep.classList.contains("step-forms-active") &&
                formStep.classList.remove("step-forms-active");
            });

            formSteps[formStepsNum].classList.add("step-forms-active");
        }

        function updateProgressbar() {
            progressSteps.forEach((progressStep, idx) => {
                if (idx < formStepsNum + 1) { 
                    progressStep.classList.add("progress-step-active"); 
                } else { 
                    progressStep.classList.remove("progress-step-active"); 
                } 
            }); 
            progressSteps.forEach((progressStep, idx)=> {
                if (idx < formStepsNum) { 
                    progressStep.classList.add("progress-step-check"); 
                } else { 
                    progressStep.classList.remove("progress-step-check"); 
                } 
            }); 
            const progressActive=document.querySelectorAll(".progress-step-active"); 
            progress.style.width=((progressActive.length - 1) / (progressSteps.length - 1)) * 100 + "%" ; 
        } 
        document.getElementById("submit-form").addEventListener("click", function () { 
            progressSteps.forEach((progressStep, idx)=> {
                if (idx <= formStepsNum) { 
                    progressStep.classList.add("progress-step-check"); 
                } else { 
                    progressStep.classList.remove("progress-step-check"); 
                } 
            }); 
            var forms=document.getElementById("forms");
            var data = new FormData(forms)
            const value = Object.fromEntries(data.entries())
            console.log(value);
            //forms.classList.remove("form"); 
            //forms.innerHTML='<div class="welcome"><div class="content"><svg class="checkmark" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 52 52"><circle class="checkmark__circle" cx="26" cy="26" r="25" fill="none"/><path class="checkmark__check" fill="none" d="M14.1 27.2l7.1 7.2 16.7-16.8"/></svg><h2>Thanks for signup!</h2><span>We will contact you soon!</span><div></div>' ; 
            
            fetch(`${apiAddress}/api/societe/register`, {
                method: 'POST',
                headers: {
                    Accept: 'application/json',
                    'Content-Type': 'application/json'
                },
                body: JSON.stringify({
                    data: value,
                })
            })
            .then((response) => response.json())
            .then((json) => {
                console.log(json);
                if(json == "Success"){
                    document.location.href='/dashboard-add-listing';
                }
                //
                
            })
            .catch((error) => {
                console.error(error);
            });

        });
    </script>

    <script>
        
        //GET
        // var mainContainer = document.getElementById("TypePack_id");
        var apiAddress = {!! json_encode($apiAddress) !!}

        //var continent = document.getElementById("continent");
        var pays = document.getElementById("pays");
        var region = document.getElementById("region");
        var ville = document.getElementById("ville");
        //var continent = document.getElementById("continent");


            /*fetch(`${apiAddress}/api/continent`,{
                headers: {
                    Accept: 'application/json',
                    'Content-Type': 'application/json'
                },
            })
            .then(function(response) {
                return response.json();
            })
            .then(function(data) {
                var mainContainer = document.getElementById("continent");
                var div = document.createElement("option");
                console.log(data);
                mainContainer.innerHTML = '';
                mainContainer.innerHTML += "<option selected disabled > Selectionez le continent </option>";
                for (var i = 0; i < data.length; i++) {
                    mainContainer.innerHTML += '<option value="' + data[i].id + '">' + data[i].libelle + '</option>';
                    // div.innerHTML = '<option value="' + data[i].id + '">' + data[i].libelle + '</option>';
                    // mainContainer.appendChild(div);
                }
                //console.log(mainContainer);
            })
            .catch(function(err) {
                console.log('error: ' + err);
            });*/
        fetch(`${apiAddress}/api/secteur`)
        .then(function(response) {
            return response.json();
        })
        .then(function(data) {
            var mainContainer = document.getElementById("secteurActivites");
            var div = document.createElement("option");
            //console.log(data);
            mainContainer.innerHTML = '';
            mainContainer.innerHTML += "<option selected disabled > Selectionez votre secteur d'activité </option>";
            for (var i = 0; i < data.length; i++) {
                mainContainer.innerHTML += '<option value="' + data[i].id + '">' + data[i].libelle + '</option>';
                // div.innerHTML = '<option value="' + data[i].id + '">' + data[i].libelle + '</option>';
                // mainContainer.appendChild(div);
            }
            //console.log(mainContainer);
        })
        .catch(function(err) {
            console.log('error: ' + err);
        })
        //------------------------------------------------------------------------------------------
        
        fetch(apiAddress+'/api/pays/pays', {
            method: 'POST',
            headers: {
                Accept: 'application/json',
                'Content-Type': 'application/json',      
            },
            body: JSON.stringify({
                continent: 1,
            })
        })
        .then((response) => response.json())
        .then((json) => {
            //console.log(json)

            var mainContainer = document.getElementById("pays");
            
            //var div = document.createElement("option");
            console.log(json);
            mainContainer.innerHTML = '';
            mainContainer.innerHTML += "<option selected value='3'> Toute l'Afrique </option>";
            for (var i = 0; i < json.length; i++) {
                mainContainer.innerHTML += '<option value="' + json[i].id + '">' + json[i].libelle + '</option>';
            }
            //console.log(mainContainer);

        })
        .catch((error) => {
            console.error(error);
        });
        //------------------------------------------------------------------------------------------
            pays.addEventListener('change', function(){
                var pay= pays.options[pays.selectedIndex].value;
                console.log(pay);

                fetch(`${apiAddress}/api/region/pays`, {
                    method: 'POST',
                    headers: {
                        Accept: 'application/json',
                        'Content-Type': 'application/json'
                    },
                    body: JSON.stringify({
                        pays: pay,
                    })
                })
                    .then((response) => response.json())
                    .then((json) => {
                        //console.log(json)

                        var mainContainer = document.getElementById("region");
                        var div = document.createElement("option");
                        console.log(json);
                        var ville = document.getElementById('ville');
                        ville.innerHTML = '';
                        
                        mainContainer.innerHTML = '';
                        mainContainer.innerHTML += "<option selected disabled > Selectionez le continent </option>";
                        for (var i = 0; i < json.length; i++) {
                            mainContainer.innerHTML += '<option value="' + json[i].id + '">' + json[i].libelle + '</option>';
                            // div.innerHTML = '<option value="' + data[i].id + '">' + data[i].libelle + '</option>';
                            // mainContainer.appendChild(div);
                        }
                        //console.log(mainContainer);

                    })
                    .catch((error) => {
                        console.error(error);
                    });

            });
        //------------------------------------------------------------------------------------------
            region.addEventListener('change', function(){
                var regions= region.options[region.selectedIndex].value;
                console.log(regions);

                fetch(`${apiAddress}/api/ville/region`,{
                    method: 'POST',
                    headers: {
                        Accept: 'application/json',
                        'Content-Type': 'application/json',      
                    },
                    body: JSON.stringify({
                        region: regions,
                    })
                })
                .then((response) => response.json())
                .then((json) => {
                    console.log(json)

                    var mainContainer = document.getElementById("ville");
                    var div = document.createElement("option");
                    //console.log(json);
                    
                    mainContainer.innerHTML = '';
                    mainContainer.innerHTML += "<option selected disabled > Selectionez le continent </option>";
                    for (var i = 0; i < json.length; i++) {
                        mainContainer.innerHTML += '<option value="' + json[i].id + '">' + json[i].libelle + '</option>';
                        // div.innerHTML = '<option value="' + data[i].id + '">' + data[i].libelle + '</option>';
                        // mainContainer.appendChild(div);
                    }
                    //console.log(mainContainer);

                })
                .catch((error) => {
                    console.error(error);
                });
            });
        //-----------------------------------------------------------------------------------------
            /*ville.addEventListener('change', function(){
                var villes= ville.options[ville.selectedIndex].value;
                //console.log(continent);

                fetch('http://192.168.1.67:3000/api/quartier', {
                    method: 'POST',
                    headers: {
                        Accept: 'application/json',
                        'Content-Type': 'application/json'
                    },
                    body: JSON.stringify({
                        ville: villes,
                    })
                })
                    .then((response) => response.json())
                    .then((json) => {
                        console.log(json)

                        var mainContainer = document.getElementById("quartie");
                        var div = document.createElement("option");
                        console.log(json);
                        mainContainer.innerHTML = '';
                        mainContainer.innerHTML += "<option selected disabled > Selectionez le continent </option>";
                        for (var i = 0; i < json.length; i++) {
                            mainContainer.innerHTML += '<option value="' + json[i].id + '">' + json[i].libelle + '</option>';
                            // div.innerHTML = '<option value="' + data[i].id + '">' + data[i].libelle + '</option>';
                            // mainContainer.appendChild(div);
                        }
                        console.log(mainContainer);

                    })
                    .catch((error) => {
                        console.error(error);
                    });
            })*/
        //---------------------------------------------------------------------------------------


        /*document.getElementById('secteurActivites').addEventListener('change',function(){
            var secteur = document.getElementById('secteurActivites');
            var secteurs= secteur.options[secteur.selectedIndex].value;
            console.log(secteurs)
            fetch(`${apiAddress}/api/SousSecteur/get`, {
                    method: 'POST',
                    headers: {
                        Accept: 'application/json',
                        'Content-Type': 'application/json'
                    },
                    body: JSON.stringify({
                        secteur: secteurs,
                    })
            })
            .then((response) => response.json())
            .then((json) => {
                console.log(json)

                var mainContainer = document.getElementById("sousSecteurActivites");
                //var div = document.createElement("option");
                console.log(json);
                mainContainer.innerHTML = '';
                mainContainer.innerHTML += "<option selected disabled > Selectionez le continent </option>";
                for (var i = 0; i < json.length; i++) {
                    mainContainer.innerHTML += '<option value="' + json[i].id + '">' + json[i].libelle + '</option>';
                    // div.innerHTML = '<option value="' + data[i].id + '">' + data[i].libelle + '</option>';
                    // mainContainer.appendChild(div);
                }
                console.log(mainContainer);

            })
            .catch((error) => {
                console.error(error);
            });

        })*/
            

    </script>
@endsection