<?php

namespace App\Http\Controllers;

use Illuminate\Support\Facades\Http;
use Illuminate\Http\Request;

class UserController extends Controller{

    public function dashboard(Request $request){
        $apiAddress = $request->session()->get('apiAddress');
        return view('dashboard.dashboard')->with('apiAddress',$apiAddress);
    }
    //----------------------------------------------------------------------------------------------------------------------------------------------

    public function myprofile(Request $request){
        $apiAddress = $request->session()->get('apiAddress');
        //dd($request->id);
        $response = Http::post($apiAddress.'/api/pro/onepro', [
            'pro' => $request->id,
        ]);
        $donnee = $response->json()[0];
        //dd($donnee);
        return view('dashboard.dashboard-myprofile')->with('apiAddress',$apiAddress)->with('donnee',$donnee);
    }

    //---------------------------------------------------------------------------------------------------------------------------------------------

    public function updateProfile(Request $request){
        //dd($request);
        $apiAddress = $request->session()->get('apiAddress');
        $response = Http::post($apiAddress.'/api/pro/update', [
           'nom' => $request->nom,
           'prenom' => $request->prenom,
           'email' => $request->email,
           'description' => $request->description,
           'numero' => $request->tel1,
           'whatsapp' => $request->whatsapp,
           'facebook' => $request->facebook,
           'website' => $request->website,
           'twitter' => $request->twitter,
           'instagram' => $request->instagram,
           'vk' => $request->vk,
        ]);

        //dd($response->json());
        return redirect('/dashboard/professionel/listing');
    }

    //---------------------------------------------------------------------------------------------------------------------------------------------

    public function password(Request $request){
        $apiAddress = $request->session()->get('apiAddress');
        return view('dashboard.dashboard-password');
    }

    //---------------------------------------------------------------------------------------------------------------------------------------------

    public function addListing(Request $request){
        //dd($request->id);
        $apiAddress = $request->session()->get('apiAddress');

        $response = Http::post($apiAddress.'/api/societe', [
            'id' => $request->id,
        ]);
        $donnee = $response->json()[0];
        //dd($donnee);
        return view('dashboard.dashboard-add-listing')->with('donnee', $donnee)->with('apiAddress',$apiAddress);
    }

    //--------------------------------------------------------------------------------------------------------------------------------------------

    public function createPrfessionnel(Request $request){
        $apiAddress = $request->session()->get('apiAddress');
        $response = Http::post($apiAddress.'/api/pro/addpro', [
            'nom' => $request->nom,
            'prenom' => $request->prenom,
            'email' => $request->email,
            'description' => $request->description,
            'numero1' => $request->tel1,
            'numero2' => $request->tel2,
            'numero3' => $request->tel3,
            'whatsapp' => $request->whatsapp,
            'facebook' => $request->facebook,
            'website' => $request->website,
            'twitter' => $request->twitter,
            'instagram' => $request->instagram,
            'vk' => $request->vk,
         ]);
 
         dd($response->json());
         return redirect('/dashboard/professionel/listing');
    }

    //-------------------------------------------------------------------------------------------------------------------------------------------

    public function userAddListing(Request $request){
        //dd($id);
    }

    //-------------------------------------------------------------------------------------------------------------------------------------------

    /*public function DashboardUserAddListing(Request $request){
        return view('dashboard-add-listing');
    }*/

    public function listingSociete(Request $request){

        $apiAddress = $request->session()->get('apiAddress');

        $data = $request->session()->get('user');
        //dd($data['id']);
        $response = Http::post($request->session()->get('apiAddress').'/api/societe/user_societe?page=1&size=15', [
            'user' => $data['id'],
        ]);

        $donnee = $response->json();
        $donnee1 = $donnee[0];
        //$donnee2 = $donnee1['societe'];
        //dd($donnee);

        return view('dashboard.dashboard-listing-societe')->with('donnee', $donnee)->with('apiAddress',$apiAddress);
    }

    //--------------------------------------------------------------------------------------------------------------------------------------------

    public function listingProfessionel(Request $request){
        $apiAddress = $request->session()->get('apiAddress');
        $data = $request->session()->get('user');
        //dd($data['id']);
        $response = Http::post($apiAddress.'/api/pro/userpro', [
            'user' => $data['id'],
        ]);
        $donnee = $response->json();
        dd($donnee);

        return view('dashboard.dashboard-listing-professionnel')->with('donnee', $donnee)->with('apiAddress',$apiAddress);
    }

    //------------------------------------------------------------------------------------------------------------------------------------------

    public function createAnnonce(Request $request){
        $apiAddress = $request->session()->get('apiAddress');
        $data = $request->session()->get('user');

        return view('annonce.annonceForm')->with('apiAddress',$apiAddress)->with('user_id',$data['id'] );
    }

    //------------------------------------------------------------------------------------------------------------------------------------------

    public function createdAnnonces(Request $request){

        return redirect()->back();
    }

    //------------------------------------------------------------------------------------------------------------------------------------------

    public function listingAnnonce(Request $request){
        $apiAddress = $request->session()->get('apiAddress');
        $data = $request->session()->get('user');

        $response = Http::post($apiAddress.'/api/annonce/userannonce?page=0&size=15', [
            'user' => $data['id'],
        ]);

        //dd($response->json());
        $donnee = $response->json();

        return view('dashboard.dashboard-listing-annonce')->with('donnee', $donnee)->with('apiAddress',$apiAddress);
    }

    //------------------------------------------------------------------------------------------------------------------------------------------

    public function singleListingAnnonce(Request $request){
        $apiAddress = $request->session()->get('apiAddress');
        //$data = $request->session()->get('user');

        $response = Http::post($apiAddress.'/api/annonce/get', [
            'annonce' => $request->id,
        ]);

        $donnee = $response->json();
        //dd($donnee[0]);

        return view('annonce.singleListingAnnonce')->with('donnee', $donnee[0])->with('apiAddress',$apiAddress);
    }

    //-----------------------------------------------------------------------------------------------------------------------------------------

    public function allAnnonce(Request $request){
        $pays = $request->session()->get('pays');
        $apiAddress = $request->session()->get('apiAddress');
        $response = Http::post($apiAddress.'/api/annonce/recherche?page=0&size=15', [
            'word' => '',
            'secteur' => '',
            'pays' => $pays,
        ]);
        //dd($response->json());

        $donnee = $response->json();

        return view('annonce.listingallannonce')->with('donnee', $donnee)->with('apiAddress',$apiAddress);

    }

    //---------------------------------------------------------------------------------------------------------------------------------------

    public function Annonce(Request $request){
        $pays = $request->session()->get('pays');
        $apiAddress = $request->session()->get('apiAddress');
        $response = Http::post($apiAddress.'/api/annonce/recherche?page=0&size=15', [
            'word' => '',
            'secteur' => '',
            'pays' => $pays,
        ]);
        //dd($response->json());

        $donnee = $response->json();

        return view('annonce.listingallannonce')->with('donnee', $donnee)->with('apiAddress',$apiAddress);

    }

    public function searchAnnonce(Request $request){
        //$pays = $request->session()->get('pays');

        //dd($request);

        $apiAddress = $request->session()->get('apiAddress');

        if(!$request->secteur){
            $secteur = '';
        }else{
            $secteur = $request->secteur;
        }

        if(!$request->word){
            $word = '';
        }else{
            $word = $request->word;
        }
        
        $response = Http::post($apiAddress.'/api/annonce/recherche?page=0&size=15', [
            'word' => $word,
            'secteur' => $secteur,
            'pays' => $request->pays,

        ]);
        //dd($response->json());

        $donnee = $response->json();

        return view('annonce.searchAnnonce')->with('donnee', $donnee)->with('apiAddress',$apiAddress);

    }

}